<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Check if RevSlider installed and activated
if ( !function_exists( 'themerex_exists_revslider' ) ) {
	function themerex_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}


if (themerex_exists_revslider()) {
	if (!is_admin()) {
		add_action('wp_enqueue_scripts', 'themerex_disable_revslider_builder_styles', 20);
	}
}


// Disable Revslider builder styles on front builder.css
function themerex_disable_revslider_builder_styles() {

	wp_dequeue_style('rs-new-plugin-settings');
	wp_deregister_style('rs-new-plugin-settings');
	wp_dequeue_style('rs-new-plugin-settings-rtl');
	wp_deregister_style('rs-new-plugin-settings-rtl');
}
?>