<?php

    if ( fusion_is_element_enabled( 'fusion_arforms_popup' ) ) {

        if ( ! class_exists( 'arf_popup_fusion_elements' ) ) {

            class arf_popup_fusion_elements extends Fusion_Element {
                
                public function __construct() {

                    parent::__construct();
                    
                    add_shortcode( 'fusion_arforms_popup', [ $this, 'render_parent' ] );
                }

                public function render_parent( $args, $content = '' ) {
                    global $wp_filters;
        
                    $form_id=!empty($args['id']) ? $args['id'] : ''; 
                    $arf_trigger_type =!empty($args['type']) ? $args['type'] : 'onclick';  
                    $arf_click_type =!empty($args['click_type']) ? $args['click_type'] : 'link';  

                    //link variables
                    $link_desc = !empty($args['link_desc']) ? $args['link_desc'] : 'Click here to open Form';  
                    $link_overlay =!empty($args['link_overlay']) ? $args['link_overlay'] : '0.6';  
                    $link_modal_bgcolor =!empty($args['link_modal_bgcolor']) ? $args['link_modal_bgcolor'] : '#808080';  
                    $link_is_close_link =!empty($args['link_is_close_link']) ? $args['link_is_close_link'] : 'yes';  
                    $link_width =!empty($args['link_width']) ? $args['link_width'] : '800';  
                    $link_is_fullscreen =!empty($args['link_is_fullscreen']) ? $args['link_is_fullscreen'] : 'no';  
                    $link_modaleffect =!empty($args['link_modaleffect']) ? $args['link_modaleffect'] : 'no_animation';  
                    $link_arf_hide_popup_loggedinuser =!empty($args['link_arf_hide_popup_loggedinuser']) ? $args['link_arf_hide_popup_loggedinuser'] : 'no';  
                    $link_arf_hide_popup_on_mobile = !empty($args['link_arf_hide_popup_on_mobile']) ? $args['link_arf_hide_popup_on_mobile'] : 'no';

                    //button_varibale
                    $button_desc = !empty($args['button_desc']) ? $args['button_desc'] : 'Click here to open Form';  
                    $button_overlay =!empty($args['button_overlay']) ? $args['button_overlay'] : '0.6';  
                    $button_modal_bgcolor =!empty($args['button_modal_bgcolor']) ? $args['button_modal_bgcolor'] : '#808080';  
                    $button_is_close_link =!empty($args['button_is_close_link']) ? $args['button_is_close_link'] : 'yes';  
                    $button_width =!empty($args['button_width']) ? $args['button_width'] : '800';  
                    $button_bgcolor=!empty($args['button_bgcolor']) ? $args['button_bgcolor'] : '#000000';
                    $button_txtcolor=!empty($args['button_txtcolor']) ? $args['button_txtcolor'] : '#FFFFFF';
                    $button_is_fullscreen =!empty($args['button_is_fullscreen']) ? $args['button_is_fullscreen'] : 'no'; 
                    $button_modaleffect =!empty($args['button_modaleffect']) ? $args['button_modaleffect'] : 'no_animation';  
                    $button_arf_hide_popup_loggedinuser =!empty($args['button_arf_hide_popup_loggedinuser']) ? $args['button_arf_hide_popup_loggedinuser'] : 'no';  
                    $button_arf_hide_popup_on_mobile = !empty($args['button_arf_hide_popup_on_mobile']) ? $args['button_arf_hide_popup_on_mobile'] : 'no';

                    //image variable 
                    $image_desc = !empty($args['image_desc']) ? $args['image_desc'] : 'Click here to open Form';  
                    $image_arf_img_url = !empty($args['image_arf_img_url']) ? $args['image_arf_img_url'] : '';  
                    $image_arf_img_height = !empty($args['image_arf_img_height']) ? $args['image_arf_img_height'] : 'auto';  
                    $image_arf_img_width = !empty($args['image_arf_img_width']) ? $args['image_arf_img_width'] : 'auto';  
                    $image_arf_img_width = !empty($args['image_arf_img_width']) ? $args['image_height'] : 'auto';  
                    $image_width = !empty($args['image_width']) ? $args['image_width'] : '800';  
                    $image_modaleffect = !empty($args['image_modaleffect']) ? $args['image_modaleffect'] : 'no_animation';  
                    $image_arf_hide_popup_loggedinuser = !empty($args['image_arf_hide_popup_loggedinuser']) ? $args['image_arf_hide_popup_loggedinuser'] : 'no';
                    $image_is_fullscreen =!empty($args['image_is_fullscreen']) ? $args['image_is_fullscreen'] : 'no'; 
                    $image_overlay =!empty($args['image_overlay']) ? $args['image_overlay'] : '0.6';  
                    $image_modal_bgcolor =!empty($args['image_modal_bgcolor']) ? $args['image_modal_bgcolor'] : '#808080';
                    $image_is_close_link =!empty($args['image_is_close_link']) ? $args['image_is_close_link'] : 'yes';      
                    $image_arf_hide_popup_on_mobile = !empty($args['image_arf_hide_popup_on_mobile']) ? $args['image_arf_hide_popup_on_mobile'] : 'no';

                     //sticky_variable
                    $sticky_desc = !empty($args['sticky_desc']) ? $args['sticky_desc'] : 'Click here to open Form';  
                    $sticky_height =!empty($args['sticky_height']) ? $args['sticky_height'] : 'auto';  
                    $sticky_width =!empty($args['sticky_width']) ? $args['sticky_width'] : '800';  
                    $sticky_bgcolor=!empty($args['sticky_bgcolor']) ? $args['sticky_bgcolor'] : '#000000';
                    $sticky_txtcolor=!empty($args['sticky_txtcolor']) ? $args['sticky_txtcolor'] : '#FFFFFF';
                    $sticky_position =!empty($args['sticky_position']) ? $args['sticky_position'] : 'top';  
                    $sticky_arf_hide_popup_loggedinuser =!empty($args['sticky_arf_hide_popup_loggedinuser']) ? $args['sticky_arf_hide_popup_loggedinuser'] : 'no';  
                    $sticky_arf_hide_popup_on_mobile = !empty($args['sticky_arf_hide_popup_on_mobile']) ? $args['sticky_arf_hide_popup_on_mobile'] : 'no';

                    //fly variable
                    $fly_desc = !empty($args['fly_desc']) ? $args['fly_desc'] : 'Click here to open Form';  
                    $fly_width =!empty($args['fly_width']) ? $args['fly_width'] : '800';  
                    $fly_bgcolor=!empty($args['fly_bgcolor']) ? $args['fly_bgcolor'] : '#000000';
                    $fly_txtcolor=!empty($args['fly_txtcolor']) ? $args['fly_txtcolor'] : '#FFFFFF';
                    $fly_position =!empty($args['fly_position']) ? $args['fly_position'] : 'top';  
                    $fly_angle=!empty($args['fly_angle']) ? $args['fly_angle'] : '0';   
                    $fly_arf_hide_popup_loggedinuser =!empty($args['fly_arf_hide_popup_loggedinuser']) ? $args['fly_arf_hide_popup_loggedinuser'] : 'no'; 
                    $fly_arf_hide_popup_on_mobile = !empty($args['fly_arf_hide_popup_on_mobile']) ? $args['fly_arf_hide_popup_on_mobile'] : 'no';

                    //onload_variables
                    $onload_overlay = !empty($args['onload_overlay']) ? $args['onload_overlay'] : '0.6';
                    $onload_modal_bgcolor = !empty($args['onload_modal_bgcolor']) ? $args['onload_modal_bgcolor'] : '#808080';
                    $onload_is_close_link =!empty($args['onload_is_close_link']) ? $args['onload_is_close_link'] : 'yes';  
                    $onload_width = !empty($args['onload_width']) ? $args['onload_width'] : '800';
                    $onload_is_fullscreen = !empty($args['onload_is_fullscreen']) ? $args['onload_is_fullscreen'] : 'no';
                    $onload_modaleffect = !empty($args['onload_modaleffect']) ? $args['onload_modaleffect'] : 'no_animation';
                    $onload_arf_hide_popup_loggedinuser = !empty($args['onload_arf_hide_popup_loggedinuser']) ? $args['onload_arf_hide_popup_loggedinuser'] : 'no';
                    $onload_arf_hide_popup_on_mobile = !empty($args['onload_arf_hide_popup_on_mobile']) ? $args['onload_arf_hide_popup_on_mobile'] : 'no';

                    //on scroll variables
                    $onscroll_percentage =!empty($args['on_scroll']) ? $args['on_scroll']  : '10';  
                    $scroll_overlay =!empty($args['scroll_overlay']) ? $args['scroll_overlay']  : '0.6';  
                    $scroll_modal_bgcolor =!empty($args['scroll_modal_bgcolor']) ? $args['scroll_modal_bgcolor']  : '#808080';  
                    $scroll_is_close_link =!empty($args['scroll_is_close_link']) ? $args['scroll_is_close_link']  : 'yes';  
                    $scroll_width =!empty($args['scroll_width']) ? $args['scroll_width']  : '800';  
                    $scroll_is_fullscreen =!empty($args['scroll_is_fullscreen']) ? $args['scroll_is_fullscreen']  : 'no';  
                    $scroll_modaleffect =!empty($args['scroll_modaleffect']) ? $args['scroll_modaleffect']  : 'animation';  
                    $scroll_arf_hide_popup_loggedinuser =!empty($args['scroll_arf_hide_popup_loggedinuser']) ? $args['scroll_arf_hide_popup_loggedinuser']  : 'no';  
                    $scroll_arf_hide_popup_on_mobile = !empty($args['scroll_arf_hide_popup_on_mobile']) ? $args['scroll_arf_hide_popup_on_mobile'] : 'no';

                    //timer variables
                    $timer_interval =!empty($args['on_delay']) ? $args['on_delay'] : '0';  
                    $timer_overlay =!empty($args['timer_overlay']) ? $args['timer_overlay'] : '0.6';  
                    $timer_modal_bgcolor =!empty($args['timer_modal_bgcolor']) ? $args['timer_modal_bgcolor'] : '#808080';  
                    $timer_is_close_link =!empty($args['timer_is_close_link']) ? $args['timer_is_close_link'] : 'yes'; 
                    $timer_width =!empty($args['timer_width']) ? $args['timer_width'] : '800';  
                    $timer_is_fullscreen =!empty($args['timer_is_fullscreen']) ? $args['timer_is_fullscreen'] : 'no'; 
                    $timer_modaleffect =!empty($args['timer_modaleffect']) ? $args['timer_modaleffect'] : 'no_animation';  
                    $timer_arf_hide_popup_loggedinuser =!empty($args['timer_arf_hide_popup_loggedinuser']) ? $args['timer_arf_hide_popup_loggedinuser'] : 'no'; 
                    $timer_arf_hide_popup_on_mobile = !empty($args['timer_arf_hide_popup_on_mobile']) ? $args['timer_arf_hide_popup_on_mobile'] : 'no';

                    //on exit variables
                    $exit_overlay =!empty($args['exit_overlay']) ? $args['exit_overlay'] : '0.6';  
                    $exit_modal_bgcolor =!empty($args['exit_modal_bgcolor']) ? $args['exit_modal_bgcolor'] : '#808080';  
                    $exit_is_close_link =!empty($args['exit_is_close_link']) ? $args['exit_is_close_link'] : 'yes';  
                    $exit_width =!empty($args['exit_width']) ? $args['exit_width'] : '800';  
                    $exit_is_fullscreen =!empty($args['exit_is_fullscreen']) ? $args['exit_is_fullscreen'] : 'no'; 
                    $exit_modaleffect =!empty($args['exit_modaleffect']) ? $args['exit_modaleffect'] : 'no_animation';  
                    $exit_arf_hide_popup_loggedinuser =!empty($args['exit_arf_hide_popup_loggedinuser']) ? $args['exit_arf_hide_popup_loggedinuser'] : 'no'; 
                    $exit_arf_hide_popup_on_mobile = !empty($args['exit_arf_hide_popup_on_mobile']) ? $args['exit_arf_hide_popup_on_mobile'] : 'no';

                    //on_ideal variables
                    $idle_overlay =!empty($args['idle_overlay']) ? $args['idle_overlay'] : '0.6';  
                    $idle_modal_bgcolor =!empty($args['idle_modal_bgcolor']) ? $args['idle_modal_bgcolor'] : '#808080';  
                    $idle_is_close_link =!empty($args['idle_is_close_link']) ? $args['idle_is_close_link'] : 'yes';  
                    $idle_width =!empty($args['idle_width']) ? $args['idle_width'] : '800';  
                    $idle_is_fullscreen =!empty($args['idle_is_fullscreen']) ? $args['idle_is_fullscreen'] : 'no'; 
                    $idle_modaleffect =!empty($args['idle_modaleffect']) ? $args['idle_modaleffect'] : 'no_animation';  
                    $idle_arf_hide_popup_loggedinuser =!empty($args['idle_arf_hide_popup_loggedinuser']) ? $args['idle_arf_hide_popup_loggedinuser'] : 'no'; 
                    $inactive_min =!empty($args['inactive_min']) ? $args['inactive_min'] : '1';  
                    $idle_arf_hide_popup_on_mobile = !empty($args['idle_arf_hide_popup_on_mobile']) ? $args['idle_arf_hide_popup_on_mobile'] : 'no';
                    
                    switch($arf_trigger_type){
                        case 'onclick':
                            if( $arf_click_type == 'link' ){
                        
                                $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $link_desc . "' type='" . $arf_click_type . "' width='" . $link_width . "' modaleffect='".$link_modaleffect."'  is_fullscreen='".$link_is_fullscreen."' overlay='" . $link_overlay . "' is_close_link='" . $link_is_close_link . "' modal_bgcolor='" . $link_modal_bgcolor . "' arf_hide_popup_loggedinuser='" .$link_arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $link_arf_hide_popup_on_mobile . "' ]";                                           

                            } else if( $arf_click_type == 'button' ){
                               
                                $form_shortcode=" [ARForms_popup id=" . $form_id . " desc='" . $button_desc . "' type='" . $arf_click_type . "' width='" . $button_width . "' modaleffect='".$button_modaleffect."' is_fullscreen='".$button_is_fullscreen."' overlay='" . $button_overlay . "' is_close_link='" . $button_is_close_link . "' bgcolor='" . $button_bgcolor . "' txtcolor='" . $button_txtcolor . "' modal_bgcolor='" . $button_modal_bgcolor . "' hide_popup_for_loggedin_user='" .$button_arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $button_arf_hide_popup_on_mobile . "' ]";
                                  
                            }
                            else if( $arf_click_type == 'image' ){
                                
                                $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $image_desc . "' type='" . $arf_click_type . "' width='" . $image_width . "' modaleffect='".$image_modaleffect."' is_fullscreen='".$image_is_fullscreen."' overlay='" . $image_overlay . "' is_close_link='" . $image_is_close_link . "' arf_img_url='" . $image_arf_img_url . "' arf_img_height='" . $image_arf_img_height . "' arf_img_width='" . $image_arf_img_width . "' modal_bgcolor='" . $image_modal_bgcolor . "' hide_popup_for_loggedin_user='" .$image_arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $image_arf_hide_popup_on_mobile . "']"; 

                            }
                            else if( $arf_click_type == 'sticky' ){

                                $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $sticky_desc . "' type='" . $arf_click_type . "' position='" . $sticky_position . "' height='" . $sticky_height . "' width='" . $sticky_width . "' bgcolor='" . $sticky_bgcolor . "' txtcolor='" . $sticky_txtcolor . "' hide_popup_for_loggedin_user='" .$sticky_arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $sticky_arf_hide_popup_on_mobile . "' ]";

                            }
                            else if( $arf_click_type == 'fly' ){
                                $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $fly_desc . "' type='" . $arf_click_type . "' position='" . $fly_position . "' height='" . $sticky_height . "' width='" . $fly_width . "' angle='" . $fly_angle . "' bgcolor='" . $fly_bgcolor . "' txtcolor='" . $fly_txtcolor . "' hide_popup_for_loggedin_user='" .$fly_arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $fly_arf_hide_popup_on_mobile . "' ]";

                            }
                        break;
                        case 'onload':
                            $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $onload_width . "' modaleffect='".$onload_modaleffect."' is_fullscreen='".$onload_is_fullscreen."' overlay='" . $onload_overlay . "' is_close_link='" . $onload_is_close_link . "' modal_bgcolor='" . $onload_modal_bgcolor . "' hide_popup_for_loggedin_user='" .$onload_arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $onload_arf_hide_popup_on_mobile . "' ]";
                        break;
                        case 'scroll':
                            $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $scroll_width . "' modaleffect='".$scroll_modaleffect."' is_fullscreen='".$scroll_is_fullscreen."' on_scroll='" . $onscroll_percentage . "' overlay='" . $scroll_overlay . "' is_close_link='" . $scroll_is_close_link . "' modal_bgcolor='" . $scroll_modal_bgcolor . "' hide_popup_for_loggedin_user='" .$scroll_arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $scroll_arf_hide_popup_on_mobile . "' ]";
                        break;
                        case 'timer':
                            $form_shortcode=" [ARForms_popup id=" . $form_id . " on_delay='" . $timer_interval . "' type='" . $arf_trigger_type . "' width='" . $timer_width . "' modaleffect='".$timer_modaleffect."' is_fullscreen='".$timer_is_fullscreen."' overlay='" . $timer_overlay . "' is_close_link='" . $timer_is_close_link . "' modal_bgcolor='" . $timer_modal_bgcolor . "' hide_popup_for_loggedin_user='" .$timer_arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $timer_arf_hide_popup_on_mobile . "' ]";
                        break;
                        case 'on_exit':
                            $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $exit_width . "' modaleffect='".$exit_modaleffect."' is_fullscreen='".$exit_is_fullscreen."' is_close_link='" . $exit_is_close_link . "' modal_bgcolor='" . $exit_modal_bgcolor . "' hide_popup_for_loggedin_user='" .$exit_arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $exit_arf_hide_popup_on_mobile . "' ]";
                        break;
                        case 'on_idle':
                            $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $idle_width . "' modaleffect='".$idle_modaleffect."' is_fullscreen='".$idle_is_fullscreen."' inactive_min='".$inactive_min."' overlay='" . $idle_overlay . "' is_close_link='" . $idle_is_close_link . "' modal_bgcolor='" . $idle_modal_bgcolor . "' hide_popup_for_loggedin_user='" .$idle_arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $idle_arf_hide_popup_on_mobile . "' ]";
                        break;
                    }
            
                    return do_shortcode($form_shortcode);
            
                }

                
    
            }

            new arf_popup_fusion_elements();
        }

    }

    function fusion_builder_popup_elements_map()
    {
        global $arfversion, $wpdb, $MdlDb,$armainhelper, $arformsmain ,$arflitemainhelper;

		$arforms_forms = $MdlDb->forms;
        
        $arforms_forms_data = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `".$arforms_forms."` WHERE is_template = %d AND (status is NULL OR status = '' OR status = %s ) AND arf_is_lite_form = 0 ORDER BY id DESC", 0, 'published' ) ); //phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- Reason: $arforms_forms is table name defined globally. False Positive alarm

		$arforms_forms_list = array();
		
		$arforms_forms_list['0']            = esc_html__("Please select a form",'ARForms');
		foreach( $arforms_forms_data as $k => $value ) {
			$arforms_forms_list[$value->id]    =  $arflitemainhelper->arflitetruncate( html_entity_decode( stripslashes( $value->name ) ), 33 ) . ' (id: ' . $value->id . ')';
		}

        $arf_trigger=array(
            'onclick'      =>       esc_html__('On Click' , 'ARForms'),
            'onload'       =>       esc_html__('On Page Load' , 'ARForms'),
            'scroll'       =>       esc_html__('On Page Scroll' , 'ARForms'),
            'timer'        =>       esc_html__('On Timer(Scheduled)' , 'ARForms'),
            'on_exit'      =>       esc_html__('On Exit(Exit Intent)' , 'ARForms'),
            'on_idle'      =>       esc_html__('On Idle' , 'ARForms'),
        );

        $arf_click_type=array(
            'link'      =>       esc_html__('link' , 'ARForms'),
            'button'    =>       esc_html__('Button' , 'ARForms'),
            'image'     =>       esc_html__('Image' , 'ARForms'),
            'sticky'    =>       esc_html__('Sticky' , 'ARForms'),
            'fly'       =>       esc_html__('Fly (Sidebar)' , 'ARForms'),
        );

        $arf_overlay=array(
            '0'        =>       esc_html__('0 (None)' , 'ARForms'),
            '0.1'      =>       esc_html__('10% (None)' , 'ARForms'),
            '0.2'      =>       esc_html__('20% (None)' , 'ARForms'),
            '0.3'      =>       esc_html__('30% (None)' , 'ARForms'),
            '0.4'      =>       esc_html__('40% (None)' , 'ARForms'),
            '0.5'      =>       esc_html__('50% (None)' , 'ARForms'),
            '0.6'      =>       esc_html__('60% (None)' , 'ARForms'),
            '0.7'      =>       esc_html__('70% (None)' , 'ARForms'),
            '0.8'      =>       esc_html__('80% (None)' , 'ARForms'),
            '0.9'      =>       esc_html__('90% (None)' , 'ARForms'),
            '1'        =>       esc_html__('100% (None)' , 'ARForms'),
            
        );

        $arf_animation=array(
            'no_animation'        =>       esc_html__('No Animation' , 'ARForms'),
            'fade_in'             =>       esc_html__('Fade-In' , 'ARForms'),
            'slide_in_top'        =>       esc_html__('Slide In Top' , 'ARForms'),
            'slide_in_bottom'     =>       esc_html__('Slide In Bottom' , 'ARForms'),
            'slide_in_right'      =>       esc_html__('Slide In right' , 'ARForms'),
            'slide_in_left'       =>       esc_html__('Slide In Left' , 'ARForms'),
            'zoom_in'             =>       esc_html__('Zoom In' , 'ARForms'),
        );

        $arf_link_position=array(
            'top'               =>       esc_html__('Top' , 'ARForms'),
            'bottom'            =>       esc_html__('Bottom' , 'ARForms'),
            'left'              =>       esc_html__('Left' , 'ARForms'),
            'right'             =>       esc_html__('Right' , 'ARForms'),
        );

        $arf_button_angle=array(
            '0'                 =>       esc_html__('0' , 'ARForms'),
            '90'                =>       esc_html__('90' , 'ARForms'),
            '-90'               =>       esc_html__('-90' , 'ARForms'),
        );

        fusion_builder_map(
            fusion_builder_frontend_data(
                'arf_popup_fusion_elements',
                [
                    'name'                     => esc_html__( 'ARForms Popup', 'ARForms' ),
                    'shortcode'                => 'fusion_arforms_popup',
                    'icon'                     => 'arforms-logo',
                    'params'                   => [
                        [
                            'class'       => 'form_list_css-fusion',
                            'type'        => 'select',
                            'heading'     => esc_html__( 'Form', 'ARForms' ),
                            'param_name'  => 'id',
                            'value'       => $arforms_forms_list,
                        ],
                        [
                             'type'        => 'select',
                             'heading'     => esc_html__('MODAL TRIGGER TYPE', 'ARForms'),
                             'param_name'  => 'type',
                             'value'       => $arf_trigger,
                             'default'     => "onclick",
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('CLICK TYPES', 'ARForms'),
                            'param_name'  => 'click_type',
                            'value'       => $arf_click_type,
                            'default'     => "link",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                            ],
                        ],
                       

                        //ONCLICK-->[LINK]
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'CAPTION', 'ARForms' ),
                            'param_name'  => 'link_desc',
                            'value'       => 'Click here to open Form',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'link' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('BACKGROUND OVERLAY', 'ARForms'),
                            'param_name'  => 'link_overlay',
                            'value'       => $arf_overlay,
                            'default'     => "0.6",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'link' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'colorpicker',
                            'heading'     => esc_html__( 'Overlay Color', 'ARForms'),
                            'param_name'  => 'link_modal_bgcolor',
                            'value'     => "#808080",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'link' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Close Button', 'ARForms' ),
                            'param_name'  => 'link_is_close_link',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'yes',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'link' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'SIZE [ WIDTH (FORM WIDTH WILL BE OVERWRITTEN) ] :', 'ARForms' ),
                            'param_name'  => 'link_width',
                            'value'       => '800',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'link' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Full Screen Popup', 'ARForms' ),
                            'param_name'  => 'link_is_fullscreen',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'link' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('ANIMATION EFFECT', 'ARForms'),
                            'param_name'  => 'link_modaleffect',
                            'value'       => $arf_animation,
                            'default'     => "no_animation",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'link' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup for Logged in User', 'ARForms' ),             
                            'param_name'  => 'link_arf_hide_popup_loggedinuser',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'link' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup on Mobile Device', 'ARForms' ),             
                            'param_name'  => 'link_arf_hide_popup_on_mobile',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'link' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],

                        //ONCLICK-->[BUTTON]

                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'CAPTION', 'ARForms' ),
                            'param_name'  => 'button_desc',
                            'value'       => 'Click here to open Form',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'button' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('BACKGROUND OVERLAY', 'ARForms'),
                            'param_name'  => 'button_overlay',
                            'value'       => $arf_overlay,
                            'default'     => "0.6",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'button' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'colorpicker',
                            'heading'     => esc_html__( 'Overlay Color', 'ARForms'),
                            'param_name'  => 'button_modal_bgcolor',
                            'value'     => "#808080",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'button' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Close Button', 'ARForms' ),
                            'param_name'  => 'button_is_close_link',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'yes',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'button' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'SIZE [ WIDTH (FORM WIDTH WILL BE OVERWRITTEN) ] :', 'ARForms' ),
                            'param_name'  => 'button_width',
                            'value'       => '800',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'button' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'colorpicker',
                            'heading'     =>  esc_html__( 'Background Color', 'ARForms' ),
                            'param_name'  => 'button_bgcolor',
                            'value'     => "#000000",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'button',
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'colorpicker',
                            'heading'     =>  esc_html__( 'Text Color', 'ARForms' ),
                            'param_name'  => 'button_txtcolor',
                            'value'     => "#FFFFFF",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'button',
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Full Screen Popup', 'ARForms' ),
                            'param_name'  => 'button_is_fullscreen',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'button' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('ANIMATION EFFECT', 'ARForms'),
                            'param_name'  => 'button_modaleffect',
                            'value'       => $arf_animation,
                            'default'     => "no_animation",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'button' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup for Logged in User', 'ARForms' ),             
                            'param_name'  => 'button_arf_hide_popup_loggedinuser',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'button' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup on Mobile Device', 'ARForms' ),             
                            'param_name'  => 'button_arf_hide_popup_on_mobile',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'button' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],

                    //ONCLICK-->[IMAGE]
                    [
                        'type'        => 'hidden',
                        'heading'     => esc_html__( 'CAPTION', 'ARForms' ),
                        'param_name'  => 'image_desc',
                        'value'       => 'Click here to open Form',
                        'dependency'  => [
                            [
                                'element'  => 'type',
                                'value'    =>'onclick',
                                'operator' => '==',
                            ],
                            [
                                'element'  => 'click_type',
                                'value'    => 'image' ,
                                'operator' => '==',
                            ],
                        ],
                    ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'IMAGE URL:', 'ARForms' ),
                            'param_name'  => 'image_arf_img_url',
                            'value'       => '',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'image',
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     =>  esc_html__( 'IMAGE SIZE [ HEIGHT ]:', 'ARForms' ),
                            'param_name'  => 'image_arf_img_height',
                            'value'       => 'auto',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'image',
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'IMAGE SIZE [ WIDTH ]:', 'ARForms' ),
                            'param_name'  => 'image_arf_img_width',
                            'value'       => 'auto',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'image',
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'SIZE [ HEIGHT ]:', 'ARForms' ),
                            'param_name'  => 'image_height',
                            'value'       => 'auto',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'image' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('BACKGROUND OVERLAY', 'ARForms'),
                            'param_name'  => 'image_overlay',
                            'value'       => $arf_overlay,
                            'default'     => "0.6",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'image' ,
                                    'operator' => '==',
                                ],
                                    ],
                        ],
                        [
                            'type'        => 'colorpicker',
                            'heading'     => esc_html__( 'Overlay Color', 'ARForms'),
                            'param_name'  => 'image_modal_bgcolor',
                            'value'     => "#808080",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'image' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Close Button', 'ARForms' ),
                            'param_name'  => 'image_is_close_link',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'yes',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'image' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'SIZE [ WIDTH (FORM WIDTH WILL BE OVERWRITTEN) ] :', 'ARForms' ),
                            'param_name'  => 'image_width',
                            'value'       => '800',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    =>'image',
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Full Screen Popup', 'ARForms' ),
                            'param_name'  => 'image_is_fullscreen',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    =>'image',
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('ANIMATION EFFECT', 'ARForms'),
                            'param_name'  => 'image_modaleffect',
                            'value'       => $arf_animation,
                            'default'     => "no_animation",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'image',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup for Logged in User', 'ARForms' ),             
                            'param_name'  => 'image_arf_hide_popup_loggedinuser',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'image' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup on Mobile Device', 'ARForms' ),             
                            'param_name'  => 'image_arf_hide_popup_on_mobile',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'image' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],

                    //ONCLICK-->[STICKY]

                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'CAPTION', 'ARForms' ),
                            'param_name'  => 'sticky_desc',
                            'value'       => 'Click here to open Form',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'sticky' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'SIZE [ HEIGHT ]:', 'ARForms' ),
                            'param_name'  => 'sticky_height',
                            'value'       => 'auto',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'sticky' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'SIZE [ WIDTH (FORM WIDTH WILL BE OVERWRITTEN) ] :', 'ARForms' ),
                            'param_name'  => 'sticky_width',
                            'value'       => '800',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'sticky' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'colorpicker',
                            'heading'     =>  esc_html__( 'Background Color', 'ARForms' ),
                            'param_name'  => 'sticky_bgcolor',
                            'value'     => "#000000",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'sticky' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'colorpicker',
                            'heading'     =>  esc_html__( 'Text Color', 'ARForms' ),
                            'param_name'  => 'sticky_txtcolor',
                            'value'     => "#FFFFFF",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'sticky' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('LINK POSITION?', 'ARForms'),
                            'param_name'  => 'sticky_position',
                            'value'       => $arf_link_position,
                            'default'     => "top",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'sticky' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup for Logged in User', 'ARForms' ),             
                            'param_name'  => 'sticky_arf_hide_popup_loggedinuser',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'sticky' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup on Mobile Device', 'ARForms' ),             
                            'param_name'  => 'sticky_arf_hide_popup_on_mobile',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'onclick',
                                    'operator' => '==',
                                ],
                                [
                                    'element'  => 'click_type',
                                    'value'    => 'sticky' ,
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        
                    //ONCLICK-->[FLY]

                       [
                        'type'        => 'textfield',
                        'heading'     => esc_html__( 'CAPTION', 'ARForms' ),
                        'param_name'  => 'fly_desc',
                        'value'       => 'Click here to open Form',
                        'dependency'  => [
                            [
                                'element'  => 'type',
                                'value'    => 'onclick',
                                'operator' => '==',
                            ],
                            [
                                'element'  => 'click_type',
                                'value'    => 'fly',
                                'operator' => '==',
                            ],
                        ],
                    ],
                    [
                        'type'        => 'textfield',
                        'heading'     => esc_html__( 'SIZE [ WIDTH (FORM WIDTH WILL BE OVERWRITTEN) ] :', 'ARForms' ),
                        'param_name'  => 'fly_width',
                        'value'       => '800',
                        'dependency'  => [
                            [
                                'element'  => 'type',
                                'value'    => 'onclick',
                                'operator' => '==',
                            ],
                            [
                                'element'  => 'click_type',
                                'value'    => 'fly',
                                'operator' => '==',
                            ],
                        ],
                    ],
                    [
                        'type'        => 'colorpicker',
                        'heading'     =>  esc_html__( 'Background Color', 'ARForms' ),
                        'param_name'  => 'fly_bgcolor',
                        'value'     => "#000000",
                        'dependency'  => [
                            [
                                'element'  => 'type',
                                'value'    => 'onclick',
                                'operator' => '==',
                            ],
                            [
                                'element'  => 'click_type',
                                'value'    => 'fly',
                                'operator' => '==',
                            ],
                        ],
                    ],
                    [
                        'type'        => 'colorpicker',
                        'heading'     =>  esc_html__( 'Text Color', 'ARForms' ),
                        'param_name'  => 'fly_txtcolor',
                        'value'     => "#FFFFFF",
                        'dependency'  => [
                            [
                                'element'  => 'type',
                                'value'    => 'onclick',
                                'operator' => '==',
                            ],
                            [
                                'element'  => 'click_type',
                                'value'    => 'fly',
                                'operator' => '==',
                            ],
                        ],
                    ],
                    [
                        'type'        => 'select',
                        'heading'     => esc_html__('LINK POSITION?', 'ARForms'),
                        'param_name'  => 'fly_position',
                        'value'       => $arf_link_position,
                        'default'     => "top",
                        'dependency'  => [
                            [
                                'element'  => 'type',
                                'value'    => 'onclick',
                                'operator' => '==',
                            ],
                            [
                                'element'  => 'click_type',
                                'value'    => 'fly',
                                'operator' => '==',
                            ],
                        ],
                    ],
                    [
                        'type'        => 'select',
                        'heading'     =>  esc_html__('BUTTON ANGLE', 'ARForms'),
                        'param_name'  => 'fly_angle',
                        'value'       => $arf_button_angle,
                        'default'     => "0",
                        'dependency'  => [
                            [
                                'element'  => 'type',
                                'value'    => 'onclick',
                                'operator' => '==',
                            ],
                            [
                                'element'  => 'click_type',
                                'value'    => 'fly',
                                'operator' => '==',
                            ],
                        ],
                    ],
                    [
                        'type'        => 'radio_button_set',
                        'heading'     =>  esc_html__( 'Hide popup for Logged in User', 'ARForms' ),             
                        'param_name'  => 'fly_arf_hide_popup_loggedinuser',
                        'value'       => [
                            'yes' => esc_html__( 'Yes', 'ARForms' ),
                            'no'  => esc_html__( 'No', 'ARForms' ),
                        ],
                        'default'     => 'no',
                        'dependency'  => [
                            [
                                'element'  => 'type',
                                'value'    => 'onclick',
                                'operator' => '==',
                            ],
                            [
                                'element'  => 'click_type',
                                'value'    => 'fly',
                                'operator' => '==',
                            ],
                        ],
                    ],
                    [
                        'type'        => 'radio_button_set',
                        'heading'     =>  esc_html__( 'Hide popup on Mobile Device', 'ARForms' ),             
                        'param_name'  => 'fly_arf_hide_popup_on_mobile',
                        'value'       => [
                            'yes' => esc_html__( 'Yes', 'ARForms' ),
                            'no'  => esc_html__( 'No', 'ARForms' ),
                        ],
                        'default'     => 'no',
                        'dependency'  => [
                            [
                                'element'  => 'type',
                                'value'    => 'onclick',
                                'operator' => '==',
                            ],
                            [
                                'element'  => 'click_type',
                                'value'    => 'fly',
                                'operator' => '==',
                            ],
                        ],
                    ],
                       
                    //ONLOAD
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('BACKGROUND OVERLAY', 'ARForms'),
                            'param_name'  => 'onload_overlay',
                            'value'       => $arf_overlay,
                            'default'     => "0.6",
                            'dependency'  => [
                                        [
                                            'element'  => 'type',
                                            'value'    => 'onload',
                                            'operator' => '==',
                                        ]
                                    ],
                        ],
                        [
                            'type'        => 'colorpicker',
                            'heading'     => esc_html__( 'Overlay Color', 'ARForms'),
                            'param_name'  => 'onload_modal_bgcolor',
                            'value'     => "#808080",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onload',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Close Button', 'ARForms' ),
                            'param_name'  => 'onload_is_close_link',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'yes',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onload',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'SIZE [ WIDTH (FORM WIDTH WILL BE OVERWRITTEN) ] :', 'ARForms' ),
                            'param_name'  => 'onload_width',
                            'value'       => '800',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onload',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Full Screen Popup', 'ARForms' ),
                            'param_name'  => 'onload_is_fullscreen',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onload',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('ANIMATION EFFECT', 'ARForms'),
                            'param_name'  => 'onload_modaleffect',
                            'value'       => $arf_animation,
                            'default'     => "no_animation",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onload',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup for Logged in User', 'ARForms' ),             
                            'param_name'  => 'onload_arf_hide_popup_loggedinuser',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onload',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup on Mobile Device', 'ARForms' ),             
                            'param_name'  => 'onload_arf_hide_popup_on_mobile',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'onload',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        
                    //ONSCROLL

                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'OPEN POPUP WHEN USER SCROLL % OF PAGE AFTER PAGE LOAD', 'ARForms' ),
                            'param_name'  => 'on_scroll',
                            'value'       => '10',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'scroll',
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('BACKGROUND OVERLAY', 'ARForms'),
                            'param_name'  => 'scroll_overlay',
                            'value'       => $arf_overlay,
                            'default'     => "0.6",
                            'dependency'  => [
                                        [
                                            'element'  => 'type',
                                            'value'    => 'scroll',
                                            'operator' => '==',
                                        ]
                                    ],
                        ],
                        [
                            'type'        => 'colorpicker',
                            'heading'     => esc_html__( 'Overlay Color', 'ARForms'),
                            'param_name'  => 'scroll_modal_bgcolor',
                            'value'     => "#808080",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'scroll',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Close Button', 'ARForms' ),
                            'param_name'  => 'scroll_is_close_link',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'yes',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'scroll',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'SIZE [ WIDTH (FORM WIDTH WILL BE OVERWRITTEN) ] :', 'ARForms' ),
                            'param_name'  => 'scroll_width',
                            'value'       => '800',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'scroll',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Full Screen Popup', 'ARForms' ),
                            'param_name'  => 'scroll_is_fullscreen',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'scroll',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('ANIMATION EFFECT', 'ARForms'),
                            'param_name'  => 'scroll_modaleffect',
                            'value'       => $arf_animation,
                            'default'     => "no_animation",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'scroll',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup for Logged in User', 'ARForms' ),             
                            'param_name'  => 'scroll_arf_hide_popup_loggedinuser',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'scroll',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup on Mobile Device', 'ARForms' ),             
                            'param_name'  => 'scroll_arf_hide_popup_on_mobile',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'scroll',
                                    'operator' => '==',
                                ]
                            ],
                        ],

                    //ONTIMER

                        [
                            'type'        => 'textfield',
                            'heading'     =>  esc_html__( 'OPEN POPUP AFTER TIME INTERVAL OF', 'ARForms' ),
                            'param_name'  => 'on_delay',
                            'value'       => '0',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'timer',
                                    'operator' => '==',
                                ],
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('BACKGROUND OVERLAY', 'ARForms'),
                            'param_name'  => 'timer_overlay',
                            'value'       => $arf_overlay,
                            'default'     => "0.6",
                            'dependency'  => [
                                        [
                                            'element'  => 'type',
                                            'value'    => 'timer',
                                            'operator' => '==',
                                        ]
                                    ],
                        ],
                        [
                            'type'        => 'colorpicker',
                            'heading'     => esc_html__( 'Overlay Color', 'ARForms'),
                            'param_name'  => 'timer_modal_bgcolor',
                            'value'     => "#808080",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'timer',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Close Button', 'ARForms' ),
                            'param_name'  => 'timer_is_close_link',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'yes',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'timer',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'SIZE [ WIDTH (FORM WIDTH WILL BE OVERWRITTEN) ] :', 'ARForms' ),
                            'param_name'  => 'timer_width',
                            'value'       => '800',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'timer',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Full Screen Popup', 'ARForms' ),
                            'param_name'  => 'timer_is_fullscreen',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'timer',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('ANIMATION EFFECT', 'ARForms'),
                            'param_name'  => 'timer_modaleffect',
                            'value'       => $arf_animation,
                            'default'     => "no_animation",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'timer',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup for Logged in User', 'ARForms' ),             
                            'param_name'  => 'timer_arf_hide_popup_loggedinuser',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'timer',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup on Mobile Device', 'ARForms' ),             
                            'param_name'  => 'timer_arf_hide_popup_on_mobile',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'timer',
                                    'operator' => '==',
                                ]
                            ],
                        ],

                    //ONEXIT

                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('BACKGROUND OVERLAY', 'ARForms'),
                            'param_name'  => 'exit_overlay',
                            'value'       => $arf_overlay,
                            'default'     => "0.6",
                            'dependency'  => [
                                        [
                                            'element'  => 'type',
                                            'value'    => 'on_exit',
                                            'operator' => '==',
                                        ]
                                    ],
                        ],
                        [
                            'type'        => 'colorpicker',
                            'heading'     => esc_html__( 'Overlay Color', 'ARForms'),
                            'param_name'  => 'exit_modal_bgcolor',
                            'value'     => "#808080",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_exit',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Close Button', 'ARForms' ),
                            'param_name'  => 'exit_is_close_link',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'yes',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_exit',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'SIZE [ WIDTH (FORM WIDTH WILL BE OVERWRITTEN) ] :', 'ARForms' ),
                            'param_name'  => 'exit_width',
                            'value'       => '800',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_exit',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Full Screen Popup', 'ARForms' ),
                            'param_name'  => 'exit_is_fullscreen',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_exit',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('ANIMATION EFFECT', 'ARForms'),
                            'param_name'  => 'exit_modaleffect',
                            'value'       => $arf_animation,
                            'default'     => "no_animation",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_exit',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup for Logged in User', 'ARForms' ),             
                            'param_name'  => 'exit_arf_hide_popup_loggedinuser',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_exit',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup on Mobile Device', 'ARForms' ),             
                            'param_name'  => 'exit_arf_hide_popup_on_mobile',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_exit',
                                    'operator' => '==',
                                ]
                            ],
                        ],

                        //ON IDEAL

                         [
                            'type'        => 'select',
                            'heading'     => esc_html__('BACKGROUND OVERLAY', 'ARForms'),
                            'param_name'  => 'idle_overlay',
                            'value'       => $arf_overlay,
                            'default'     => "0.6",
                            'dependency'  => [
                                        [
                                            'element'  => 'type',
                                            'value'    => 'on_idle',
                                            'operator' => '==',
                                        ]
                                    ],
                        ],
                        [
                            'type'        => 'colorpicker',
                            'heading'     => esc_html__( 'Overlay Color', 'ARForms'),
                            'param_name'  => 'idle_modal_bgcolor',
                            'value'     => "#808080",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_idle',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Close Button', 'ARForms' ),
                            'param_name'  => 'idle_is_close_link',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'yes',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_idle',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_html__( 'SIZE [ WIDTH (FORM WIDTH WILL BE OVERWRITTEN) ] :', 'ARForms' ),
                            'param_name'  => 'idle_width',
                            'value'       => '800',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_idle',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Show Full Screen Popup', 'ARForms' ),
                            'param_name'  => 'idle_is_fullscreen',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_idle',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__('ANIMATION EFFECT', 'ARForms'),
                            'param_name'  => 'idle_modaleffect',
                            'value'       => $arf_animation,
                            'default'     => "no_animation",
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_idle',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup for Logged in User', 'ARForms' ),             
                            'param_name'  => 'idle_arf_hide_popup_loggedinuser',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_idle',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'radio_button_set',
                            'heading'     =>  esc_html__( 'Hide popup on Mobile Device', 'ARForms' ),             
                            'param_name'  => 'idle_arf_hide_popup_on_mobile',
                            'value'       => [
                                'yes' => esc_html__( 'Yes', 'ARForms' ),
                                'no'  => esc_html__( 'No', 'ARForms' ),
                            ],
                            'default'     => 'no',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    => 'on_idle',
                                    'operator' => '==',
                                ]
                            ],
                        ],
                        [
                            'type'        => 'textfield',
                            'heading'     =>  esc_html__( 'SHOW AFTER USER IS INACTIVE FOR:', 'ARForms' ),
                            'param_name'  => 'inactive_min',
                            'value'       => '1',
                            'dependency'  => [
                                [
                                    'element'  => 'type',
                                    'value'    =>'on_idle',
                                    'operator' => '==',
                                ],
                            ],
                        ],
                    ],
                   
                ]
            )
        );
    }

    add_action( 'fusion_builder_before_init', 'fusion_builder_popup_elements_map' );
?>