<?php

class arforms_popup_divi_module extends ET_Builder_Module{
    public $slug       = 'arforms_divi_popup';
    public $vb_support = 'on';

    protected $module_credits = array(
		'module_uri' => 'https://www.arformsplugin.com',
		'author'     => 'Repute infosystems',
		'author_uri' => 'https://www.arformsplugin.com',
	);

	public function init() {
		$this->name = esc_html__( 'ARForms Popup', 'ARForms' );
	}
	
	public function get_fields() {

		global $arfversion, $wpdb, $MdlDb,$armainhelper, $arformsmain;

		$arforms_forms = $MdlDb->forms;
        
        $arforms_forms_data = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `".$arforms_forms."` WHERE is_template = %d AND (status is NULL OR status = '' OR status = %s ) AND arf_is_lite_form = 0 ORDER BY id DESC", 0, 'published' ) ); //phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- Reason: $arforms_forms is table name defined globally. False Positive alarm

		$arforms_forms_list = array();
		
		$arforms_forms_list['0']            = esc_html__("Please select a form",'ARForms');
		foreach( $arforms_forms_data as $k => $value ) {
			$arforms_forms_list[$value->id]    = $value->name . ' (id: ' . $value->id . ')';
		}

		$arf_trigger=array(
            'onclick'      =>       esc_html__('On Click' , 'ARForms'),
            'onload'       =>       esc_html__('On Page Load' , 'ARForms'),
            'scroll'       =>       esc_html__('On Page Scroll' , 'ARForms'),
            'timer'        =>       esc_html__('On Timer(Scheduled)' , 'ARForms'),
            'on_exit'      =>       esc_html__('On Exit(Exit Intent)' , 'ARForms'),
            'on_idle'      =>       esc_html__('On Idle' , 'ARForms'),
        );

		$arf_click_type=array(
            'link'      =>       esc_html__('link' , 'ARForms'),
            'button'    =>       esc_html__('Button' , 'ARForms'),
            'image'     =>       esc_html__('Image' , 'ARForms'),
            'sticky'    =>       esc_html__('Sticky' , 'ARForms'),
            'fly'       =>       esc_html__('Fly (Sidebar)' , 'ARForms'),
        );

		$arf_overlay=array(
            '0'        =>       esc_html__('0 (None)' , 'ARForms'),
            '0.1'      =>       esc_html__('10% (None)' , 'ARForms'),
            '0.2'      =>       esc_html__('20% (None)' , 'ARForms'),
            '0.3'      =>       esc_html__('30% (None)' , 'ARForms'),
            '0.4'      =>       esc_html__('40% (None)' , 'ARForms'),
            '0.5'      =>       esc_html__('50% (None)' , 'ARForms'),
            '0.6'      =>       esc_html__('60% (None)' , 'ARForms'),
            '0.7'      =>       esc_html__('70% (None)' , 'ARForms'),
            '0.8'      =>       esc_html__('80% (None)' , 'ARForms'),
            '0.9'      =>       esc_html__('90% (None)' , 'ARForms'),
            '1'        =>       esc_html__('100% (None)' , 'ARForms'),
            
        );

		$arf_animation=array(
            'no_animation'        =>       esc_html__('No Animation' , 'ARForms'),
            'fade_in'             =>       esc_html__('Fade-In' , 'ARForms'),
            'slide_in_top'        =>       esc_html__('Slide In Top' , 'ARForms'),
            'slide_in_bottom'     =>       esc_html__('Slide In Bottom' , 'ARForms'),
            'slide_in_right'      =>       esc_html__('Slide In right' , 'ARForms'),
            'slide_in_left'       =>       esc_html__('Slide In Left' , 'ARForms'),
            'zoom_in'             =>       esc_html__('Zoom In' , 'ARForms'),
        );

		$arf_toggle_data=array(
			'off '    => esc_html__( 'no', 'ARForms' ),
			'on'     => esc_html__( 'Yes', 'ARForms' ),
		);

		$arf_link_position=array(
            'top'               =>       esc_html__('Top' , 'ARForms'),
            'bottom'            =>       esc_html__('Bottom' , 'ARForms'),
            'left'              =>       esc_html__('Left' , 'ARForms'),
            'right'             =>       esc_html__('Right' , 'ARForms'),
        );

		$arf_button_angle=array(
            '0'                 =>       esc_html__('0' , 'ARForms'),
            '90'                =>       esc_html__('90' , 'ARForms'),
            '-90'               =>       esc_html__('-90' , 'ARForms'),
        );

		return array(
			'form_popup_id'    => [
				'label'           => esc_html__( 'Form', 'ARForms' ),
				'type'            => 'select',
				'default'       => '0',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'options'         => $arforms_forms_list,
			],
			'arf_trigger_type'    => [
				'label'         => esc_html__('MODAL TRIGGER TYPE', 'ARForms'),
				'type'            => 'select',
				'default'        => 'onclick',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'options'         => $arf_trigger,
			],
			'arf_click_type'    => [
				'label'         => esc_html__('CLICK TYPES', 'ARForms'),
				'type'            => 'select',
				'default'        => 'link',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'options'         => $arf_click_type,
				'show_if'         => array(
					'arf_trigger_type' => 'onclick',
				),
			],
			'arf_scroll_percentage'     => array(
				'label'         => esc_html__( 'OPEN POPUP WHEN USER SCROLL % OF PAGE AFTER PAGE LOAD', 'ARForms' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'default'       => '10',
				'show_if'         => array(
					'arf_trigger_type' => array('scroll'),
				),
			),
			'arf_time_interval'     => array(
				'label'         => esc_html__( 'OPEN POPUP AFTER TIME INTERVAL OF', 'ARForms' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'default'       => '0',
				'show_if'         => array(
					'arf_trigger_type' => array('timer'),
				),
			),
			'arf_caption'     => array(
				'label'         => esc_html__( 'CAPTION', 'ARForms' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'default'       => 'Click here to open Form',
				'show_if'         => array(
					'arf_trigger_type' => array('onclick'),
					'arf_click_type' => array('link','button','sticky','fly'),
				),
			),
			'arf_background_overlay'    => [
				'label'         => esc_html__('BACKGROUND OVERLAY', 'ARForms'),
				'type'            => 'select',
				'default'        => '0.6',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'options'         => $arf_overlay,
				'show_if'         => array(
					'arf_trigger_type' => array('onclick','onload','scroll','timer', 'on_exit','on_idle'),
					'arf_click_type' => array('link','button'),
				),
			],
			'arf_overlay_color'     => array(
				'label'         => esc_html__( 'Overlay Color', 'ARForms' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'default'       => '#D3D3D3',
				'show_if'         => array(
					'arf_trigger_type' => array('onclick','onload','scroll','timer', 'on_exit','on_idle'),
					'arf_click_type' => array('link','button'),
				),
			),
			'arf_show_close_button'    => [
				'label'   => esc_html__( 'Show Close Button', 'ARForms' ),
				'type'            => 'yes_no_button',
				'default' => 'on',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'options'         => $arf_toggle_data,
				'show_if'         => array(
					'arf_trigger_type' => array('onclick','onload','scroll','timer', 'on_exit','on_idle'),
					'arf_click_type' => array('link','button'),
				),
			],
			'arf_image_url'     => array(
				'label'         => esc_html__( 'IMAGE URL:', 'ARForms' ),
				'type'            => 'text',
				'default'       => '0',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'show_if'         => array(
					'arf_trigger_type' => array('onclick'),
					'arf_click_type' => array('image'),
				),
			),
			'arf_image_height'     => array(
				'label'         => esc_html__( 'IMAGE SIZE [ HEIGHT ]:', 'ARForms' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'default'       => 'auto',
				'show_if'         => array(
					'arf_trigger_type' => array('onclick'),
					'arf_click_type' => array('image'),
				),
			),
			'arf_image_width'     => array(
				'label'         => esc_html__( 'IMAGE SIZE [ WIDTH ]:', 'ARForms' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'default'       => 'auto',
				'show_if'         => array(
					'arf_trigger_type' => array('onclick'),
					'arf_click_type' => array('image'),
				),
			),
			'arf_size_height'     => array(
				'label'         => esc_html__( 'SIZE [ HEIGHT ]:', 'ARForms' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'default'       => 'auto',
				'show_if'         => array(
					'arf_trigger_type' => array('onclick'),
					'arf_click_type' => array('image','sticky'),
				),
			),
			'arf_size_width'     => array(
				'label'         => esc_html__( 'SIZE [ WIDTH (FORM WIDTH WILL BE OVERWRITTEN) ] :', 'ARForms' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'default'       => '800',
				'show_if'         => array(
					'arf_trigger_type' => array('onclick','onload','scroll', 'on_exit','on_idle'),
					'arf_click_type' => array('link','button','image','sticky','fly'),
				),
			),
			'arf_background_color'     => array(
				'label'         => esc_html__( 'Background Color', 'ARForms' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'default'       => '#000000',
				'show_if'         => array(
					'arf_trigger_type' => array('onclick',),
					'arf_click_type' => array('button','sticky','fly'),
				),
			),
			'arf_text_color'     => array(
				'label'         => esc_html__( 'Text Color', 'ARForms' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'default'       => '#FFFFFF',
				'show_if'         => array(
					'arf_trigger_type' => array('onclick',),
					'arf_click_type' => array('button','sticky','fly'),
				),
			),
			'arf_show_full_screen_popup'    => [
				'label'   => esc_html__( 'Show Full Screen Popup', 'ARForms' ),
				'type'            => 'yes_no_button',
				'default'       => 'off',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'options'         => $arf_toggle_data,
				'show_if'         => array(
					'arf_trigger_type' => array('onclick','onload','scroll','timer', 'on_exit','on_idle'),
					'arf_click_type' => array('link','button'),
				),
			],
			'arf_animation'    => [
				'label'         => esc_html__('ANIMATION EFFECT', 'ARForms'),
				'type'            => 'select',
				'default'       => 'no_animation',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'options'         => $arf_animation,
				'show_if'         => array(
					'arf_trigger_type' => array('onclick','onload','scroll','timer','on_exit','on_idle'),
					'arf_click_type' => array('link','button'),
				),
			],
			'arf_link_position'    => [
				'label'         => esc_html__('LINK POSITION?', 'ARForms'),
				'type'            => 'select',
				'default'       => 'top',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'options'         => $arf_link_position,
				'show_if'         => array(
					'arf_trigger_type' => array('onclick'),
					'arf_click_type' => array('fly','sticky'),
				),
			],
			'arf_button_angle'    => [
				'label'         => esc_html__('BUTTON ANGLE', 'ARForms'),
				'type'            => 'select',
				'default'       => '0',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'options'         => $arf_button_angle,
				'show_if'         => array(
					'arf_trigger_type' => array('onclick'),
					'arf_click_type' => array('fly'),
				),
			],
			'arf_hide_popup_loggedinuser'    => [
				'label'   => esc_html__( 'Hide popup for Logged in User', 'ARForms' ),
				'type'            => 'yes_no_button',
				'default'       => 'off',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'options'         => $arf_toggle_data,
				'show_if'         => array(
					'arf_trigger_type' => array('onclick','onload','scroll','timer', 'on_exit','on_idle'),
					'arf_click_type' => array('link','button','image','sticky','fly'),
				),
			],
			// hiding popup on mobile field 
            'arf_hide_popup_on_mobile'    => [
				'label'   => esc_html__( 'Hide popup on Mobile Device', 'ARForms' ),
				'type'            => 'yes_no_button',
				'default'       => 'off',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'options'         => $arf_toggle_data,
				'show_if'         => array(
					'arf_trigger_type' => array('onclick','onload','scroll','timer', 'on_exit','on_idle'),
					'arf_click_type' => array('link','button','image','sticky','fly'),
				),
			],
			'arf_inactive_minute'     => array(
				'label'         => esc_html__( 'SHOW AFTER USER IS INACTIVE FOR:', 'ARForms' ),
				'type'            => 'text',
				'default'       => '1',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'main_content',
				'show_if'         => array(
					'arf_trigger_type' => array('on_idle'),
				),
			),
		);
	}
	

	public function get_advanced_fields_config() {

		return [
			'link_options' => false,
			'text'         => false,
			'background'   => false,
			'borders'      => false,
			'box_shadow'   => false,
			'button'       => false,
			'filters'      => false,
			'fonts'        => false,
		];
	}

	public function render( $attrs, $content = null, $render_slug='' ) {
		$form_string="";
		
		$form_id=$this->props['form_popup_id'];
        $arf_trigger_type =$this->props['arf_trigger_type'];
        $arf_click_type =$this->props['arf_click_type'];
        $arf_scroll_percentage =$this->props['arf_scroll_percentage'];
        $arf_time_interval =$this->props['arf_time_interval'];
        $arf_caption =$this->props['arf_caption'];
        $arf_background_overlay =$this->props['arf_background_overlay'];
        $arf_overlay_color =$this->props['arf_overlay_color'];
        $arf_show_close_button =$this->props['arf_show_close_button'];
        $arf_image_url= $this->props['arf_image_url'];
        $arf_image_height =$this->props['arf_image_height'];
        $arf_image_width =$this->props['arf_image_width'];
        $arf_size_height =$this->props['arf_size_height'];
        $arf_size_width =$this->props['arf_size_width'];
        $arf_background_color=$this->props['arf_background_color'];
        $arf_text_color=$this->props['arf_text_color'];
        $arf_show_full_screen_popup =$this->props['arf_show_full_screen_popup'];
        $arf_animation =$this->props['arf_animation'];
        $arf_link_position =$this->props['arf_link_position'];
        $arf_button_angle =$this->props['arf_button_angle'];
        $arf_hide_popup_loggedinuser =$this->props['arf_hide_popup_loggedinuser'];
        $arf_inactive_minute =$this->props['arf_inactive_minute'];
		$arf_hide_popup_on_mobile = $this->props['arf_hide_popup_on_mobile'];

		if($arf_show_close_button == "on")
        {
            $arf_show_close_button ="yes";
        }
        elseif($arf_show_close_button == "off")
        {
            $arf_show_close_button ="no";
        }

        if($arf_show_full_screen_popup == "on")
        {
            $arf_show_full_screen_popup ="yes";
        }
        elseif($arf_show_full_screen_popup == "off")
        {
            $arf_show_full_screen_popup ="no";
        }

        if($arf_hide_popup_loggedinuser == "on")
        {
            $arf_hide_popup_loggedinuser ="yes";
        }
        elseif($arf_hide_popup_loggedinuser == "off")
        {
            $arf_hide_popup_loggedinuser ="no";
        }

        if($arf_hide_popup_on_mobile == "on")
        {
            $arf_hide_popup_on_mobile ="yes";
        }
        elseif($arf_hide_popup_on_mobile == "off")
        {
            $arf_hide_popup_on_mobile ="no";
        }

		$form_shortcode="";
     

        switch($arf_trigger_type){
            case 'onclick':
                if( $arf_click_type == 'link' ){
                    $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."'  is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' modal_bgcolor='" . $arf_overlay_color . "' arf_hide_popup_loggedinuser='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                } else if( $arf_click_type == 'button' ){
                    $form_shortcode=" [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                }
                else if( $arf_click_type == 'image' ){
                    $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' arf_img_url='" . $arf_image_url . "' arf_img_height='" . $arf_image_height . "' arf_img_width='" . $arf_image_width . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "']"; 
                }
                else if( $arf_click_type == 'sticky' ){
                    $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' position='" . $arf_link_position . "' height='" . $arf_size_height . "' width='" . $arf_size_width . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                }
                else if( $arf_click_type == 'fly' ){
                    $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' position='" . $arf_link_position . "' height='" . $arf_size_height . "' width='" . $arf_size_width . "' angle='" . $arf_button_angle . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                }
            break;
            case 'onload':
                $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
            break;
            case 'scroll':
                $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_close_button."' on_scroll='" . $arf_scroll_percentage . "' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
            break;
            case 'timer':
                $form_shortcode=" [ARForms_popup id=" . $form_id . " on_delay='" . $arf_time_interval . "' type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
            break;
            case 'on_exit':
                $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' is_close_link='" . $arf_show_close_button . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
            break;
            case 'on_idle':
                $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' inactive_min='".$arf_inactive_minute."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
            break;
        }

		

        return do_shortcode($form_shortcode);
	}
}

new arforms_popup_divi_module;