<?php

class arforms_popup_divi_extension extends DiviExtension{
    /**
	 * The gettext domain for the extension's translations.
	 *
	 * @since 6.2
	 *
	 * @var string
	 */
	public $gettext_domain = 'ARForms';

    /**
	 * The extension's WP Plugin name.
	 *
	 * @since 6.2
	 *
	 * @var string
	 */
	public $name = 'arforms-popup-divi-module';

	/**
	 * The extension's version
	 *
	 * @since 6.2
	 *
	 * @var string
	 */
	public $version = '6.3';

    /**
	 * arforms_divi_extension constructor.
	 *
	 * @param string $name
	 * @param array  $args
	 */
    public function __construct( $name = 'arforms-popup-divi-module', $args = array() ) {
		
		$this->plugin_dir     = plugin_dir_path( __FILE__ );
		$this->plugin_dir_url = plugin_dir_url( $this->plugin_dir.'/Divi/' );
		$this->_builder_js_data  = [
			'i10n' => [
				'arformsdivi_module_data' => [
					'arformsdivi_ajax_url' => admin_url( 'admin-ajax.php' )
				]
			]
		];
		parent::__construct( $name, $args );
	}
}

new arforms_popup_divi_extension;