<?php
class ArfProBeaverModule extends FLBuilderModule {

    public function __construct()
    {
        $arformslogo = '<svg width="24" height="24"  viewBox="-3 -1 23 20.22" aria-hidden="true"  focusable="false" style="fill: rgb(73, 107, 222);">
                            <path d="M17.076,11.591c-0.12,0.427-0.021,0.64,0.3,0.64c0.4,0,0.9-0.358,1.5-1.078 c0.041-0.044,0.08-0.067,0.121-0.067c0.14,0,0.295,0.096,0.465,0.287c0.17,0.19,0.255,0.354,0.255,0.488	c0,0.045-0.011,0.078-0.03,0.101c-1.52,2.021-2.98,3.032-4.381,3.032c-0.76,0-1.141-0.494-1.141-1.482 	c0-0.674,0.211-1.504,0.631-2.493l-0.18-0.101c-0.821,1.145-1.736,2.111-2.746,2.897c-1.011,0.786-1.855,1.179-2.536,1.179	c-0.72,0-1.29-0.303-1.71-0.909c-0.42-0.606-0.63-1.358-0.63-2.258c0-2.245,0.86-4.616,2.581-7.109 	c1.841-2.695,3.801-4.043,5.882-4.043c0.619,0,1.141,0.168,1.561,0.505l0.3-0.809C17.396,0.124,17.687,0,18.187,0 	c0.42,0,0.84,0.079,1.26,0.236c0.421,0.157,0.61,0.315,0.57,0.472L17.076,11.591z M15.06,2.055c-1.299,0-2.479,1.292-3.537,3.875 	c-0.859,2.157-1.288,3.942-1.288,5.357c0,0.36,0.065,0.69,0.194,0.994c0.131,0.304,0.295,0.454,0.496,0.454 	c0.7,0,1.57-0.773,2.611-2.324c1.04-1.549,1.801-3.2,2.281-4.952l0.71-2.632C16.228,2.313,15.737,2.055,15.06,2.055z M3.485,4.998 	c-0.261,0-0.472-0.179-0.472-0.4V3.391c0-0.221,0.211-0.4,0.472-0.4h5.072c0.243,0,0.441,0.157,0.467,0.357 	C8.407,3.764,7.793,4.324,7.22,4.998H3.485z M3.505,6.999h3.501C6.682,7.446,6.393,7.981,6.161,8.575 	C6.092,8.708,6.026,8.843,5.966,8.979H3.505c-0.274,0-0.497-0.176-0.497-0.395v-1.19C3.009,7.177,3.231,6.999,3.505,6.999z 	 M1.612,8.979H0.403C0.181,8.979,0,8.804,0,8.585v-1.19c0-0.218,0.181-0.396,0.403-0.396h1.209c0.222,0,0.403,0.178,0.403,0.396  	v1.19C2.015,8.804,1.834,8.979,1.612,8.979z M1.604,4.998H0.401C0.18,4.998,0,4.818,0,4.598V3.391c0-0.221,0.18-0.4,0.401-0.4h1.203 	c0.222,0,0.401,0.18,0.401,0.4v1.207C2.005,4.818,1.826,4.998,1.604,4.998z M0.403,10.981H1.61c0.223,0,0.403,0.18,0.403,0.4v1.207 c0,0.221-0.18,0.4-0.403,0.4H0.403C0.18,12.989,0,12.81,0,12.589v-1.207C0,11.161,0.18,10.981,0.403,10.981z M3.567,10.981h2.21	c-0.081,0.72,0.003,1.402,0.228,2.008H3.567c-0.306,0-0.554-0.18-0.554-0.4v-1.207C3.013,11.161,3.261,10.981,3.567,10.981z"></path>
                        </svg>';
        parent::__construct(array(
            'name'          => __('ARForms Popup', 'ARForms'),
            'description'   => __('Select and display one of your forms For Popup.', 'ARForms'),
            'category'		=> __('ARForms', 'ARForms'),
            'dir'           => FORMPATH . '/integrations/Beaver_Builder/modules/arf_pro_beaver_builder_module/',
            'url'           => ARFURL . '/integrations/Beaver_Builder/modules/arf_pro_beaver_builder_module/',
            'editor_export' => true,
            'enabled'       => true,
            'icon'          =>$arformslogo
        ));

        if ( isset($this->settings) && is_object($this->settings) && !empty($this->settings->arf_trigger_type) ) {
        
            $arf_hide_popup_on_mobile = !empty($this->settings->arf_hide_popup_on_mobile) ? $this->settings->arf_hide_popup_on_mobile : 'no';

            switch($this->settings->arf_trigger_type){
                case 'onclick':
                    if( $this->settings->arf_click_type == 'link' ){
                        $this->settings->shortcode = " [ARForms_popup id=" . $this->settings->arf_forms_list . " desc='" . $this->settings->arf_caption . "' type='" . $this->settings->arf_click_type . "' width='" . $this->settings->arf_size_width . "' modaleffect='".$this->settings->arf_animation."'  is_fullscreen='".$this->settings->arf_show_full_screen_popup."' overlay='" . $this->settings->arf_background_overlay . "' is_close_link='" . $this->settings->arf_show_close_button . "' modal_bgcolor='" . $this->settings->arf_overlay_color . "' hide_popup_for_loggedin_user='" .$this->settings->arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                    } else if( $this->settings->arf_click_type == 'button' ){
                        $this->settings->shortcode = " [ARForms_popup id=" . $this->settings->arf_forms_list . " desc='" . $this->settings->arf_caption . "' type='" . $this->settings->arf_click_type . "' width='" . $this->settings->arf_size_width . "' modaleffect='".$this->settings->arf_animation."' is_fullscreen='".$this->settings->arf_show_full_screen_popup."' overlay='" . $this->settings->arf_background_overlay . "' is_close_link='" . $this->settings->arf_show_close_button . "' bgcolor='" . $this->settings->arf_background_color . "' txtcolor='" . $this->settings->arf_text_color . "' modal_bgcolor='" . $this->settings->arf_overlay_color . "' hide_popup_for_loggedin_user='" .$this->settings->arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                    }
                    else if( $this->settings->arf_click_type == 'image' ){
                        $this->settings->shortcode = " [ARForms_popup id=" . $this->settings->arf_forms_list . " desc='" . $this->settings->arf_caption . "' type='" . $this->settings->arf_click_type . "' width='" . $this->settings->arf_size_width . "' modaleffect='".$this->settings->arf_animation."' is_fullscreen='".$this->settings->arf_show_full_screen_popup."' overlay='" . $this->settings->arf_background_overlay . "' is_close_link='" . $this->settings->arf_show_close_button . "' arf_img_url='" . $this->settings->arf_image_url . "' arf_img_height='" . $this->settings->arf_image_height . "' arf_img_width='" . $this->settings->arf_image_width . "' modal_bgcolor='" . $this->settings->arf_overlay_color . "' hide_popup_for_loggedin_user='" .$this->settings->arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "']"; 
                    }
                    else if( $this->settings->arf_click_type == 'sticky' ){
                        $this->settings->shortcode = " [ARForms_popup id=" . $this->settings->arf_forms_list . " desc='" . $this->settings->arf_caption . "' type='" . $this->settings->arf_click_type . "' position='" . $this->settings->arf_link_position . "' height='" . $this->settings->arf_size_height . "' width='" . $this->settings->arf_size_width . "' bgcolor='" . $this->settings->arf_background_color . "' txtcolor='" . $this->settings->arf_text_color . "' hide_popup_for_loggedin_user='" .$this->settings->arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                    }
                    else if( $this->settings->arf_click_type == 'fly' ){
                        $this->settings->shortcode = " [ARForms_popup id=" . $this->settings->arf_forms_list . " desc='" . $this->settings->arf_caption . "' type='" . $this->settings->arf_click_type . "' position='" . $this->settings->arf_link_position . "' height='" . $this->settings->arf_size_height . "' width='" . $this->settings->arf_size_width . "' angle='" . $this->settings->arf_button_angle . "' bgcolor='" . $this->settings->arf_background_color . "' txtcolor='" . $this->settings->arf_text_color . "' hide_popup_for_loggedin_user='" .$this->settings->arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                    }
                break;
                case 'onload':
                    $this->settings->shortcode = " [ARForms_popup id=" . $this->settings->arf_forms_list . " type='" . $this->settings->arf_trigger_type . "' width='" . $this->settings->arf_size_width . "' modaleffect='".$this->settings->arf_animation."' is_fullscreen='".$this->settings->arf_show_full_screen_popup."' overlay='" . $this->settings->arf_background_overlay . "' is_close_link='" . $this->settings->arf_show_close_button . "' modal_bgcolor='" . $this->settings->arf_overlay_color . "' hide_popup_for_loggedin_user='" .$this->settings->arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                break;
                case 'scroll':
                    $this->settings->shortcode = " [ARForms_popup id=" . $this->settings->arf_forms_list . " type='" . $this->settings->arf_trigger_type . "' width='" . $this->settings->arf_size_width . "' modaleffect='".$this->settings->arf_animation."' is_fullscreen='".$this->settings->arf_show_close_button."' on_scroll='" . $this->settings->arf_scroll_percentage . "' overlay='" . $this->settings->arf_background_overlay . "' is_close_link='" . $this->settings->arf_show_close_button . "' modal_bgcolor='" . $this->settings->arf_overlay_color . "' hide_popup_for_loggedin_user='" .$this->settings->arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                break;
                case 'timer':
                    $this->settings->shortcode = " [ARForms_popup id=" . $this->settings->arf_forms_list . " on_delay='" . $this->settings->arf_time_interval . "' type='" . $this->settings->arf_trigger_type . "' width='" . $this->settings->arf_size_width . "' modaleffect='".$this->settings->arf_animation."' is_fullscreen='".$this->settings->arf_show_full_screen_popup."' overlay='" . $this->settings->arf_background_overlay . "' is_close_link='" . $this->settings->arf_show_close_button . "' modal_bgcolor='" . $this->settings->arf_overlay_color . "' hide_popup_for_loggedin_user='" .$this->settings->arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                break;
                case 'on_exit':
                    $this->settings->shortcode = " [ARForms_popup id=" . $this->settings->arf_forms_list . " type='" . $this->settings->arf_trigger_type . "' width='" . $this->settings->arf_size_width . "' modaleffect='".$this->settings->arf_animation."' is_fullscreen='".$this->settings->arf_show_full_screen_popup."' is_close_link='" . $this->settings->arf_show_close_button . "' modal_bgcolor='" . $this->settings->arf_overlay_color . "' hide_popup_for_loggedin_user='" .$this->settings->arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                break;
                case 'on_idle':
                    $this->settings->shortcode = " [ARForms_popup id=" . $this->settings->arf_forms_list . " type='" . $this->settings->arf_trigger_type . "' width='" . $this->settings->arf_size_width . "' modaleffect='".$this->settings->arf_animation."' is_fullscreen='".$this->settings->arf_show_full_screen_popup."' inactive_min='".$this->settings->arf_inactive_minute."' overlay='" . $this->settings->arf_background_overlay . "' is_close_link='" . $this->settings->arf_show_close_button . "' modal_bgcolor='" . $this->settings->arf_overlay_color . "' hide_popup_for_loggedin_user='" .$this->settings->arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                break;
            }
        }

        $this->add_css('arfdisplaycss');
        $this->add_css('arf_selectpicker');
        $this->add_css('nouislider');

    }

    public function update($settings)
        {
            if($settings->arf_trigger_type != "onclick")
            {
                $settings->arf_click_type = "";
            }

            return $settings;
        }
}

global $arf_pro_beaver_builder;

FLBuilder::register_module('ArfProBeaverModule', array(
    'general'       => array( 
        'title'         => __('General', 'ARForms'), 
        'sections'      => array( 
            'general'       => array(
                'title'         => __('Form Settings', 'ARForms'), 
                'fields'        => array( 
                    'arf_forms_list'   => array(
                        'type'          => 'select',
                        'label'         => __('Select Form', 'ARForms'),
                        'options'       => $arf_pro_beaver_builder->arf_enqueue_beaver_builder_assets(),
                    ),
                    'arf_trigger_type'   => array(
                        'type'          => 'select',
                        'label'         => __('MODAL TRIGGER TYPE', 'ARForms'),
                        'default'       => 'onclick',
                        'options'       => $arf_pro_beaver_builder->arf_get_trigger_type_assets(),
                        'toggle'        => array(
                            'onclick'      => array(
                                'fields'        => array( 'arf_click_type' , 'arf_caption' , 'arf_background_overlay' , 'arf_overlay_color' , 'arf_size_width' , 'arf_animation' , 'arf_background_color' , 'arf_text_color' , 'arf_image_url' , 'arf_image_height' , 'arf_image_width' , 'arf_size_height' , 'arf_link_position' , 'arf_button_angle' , 'arf_show_close_button' , 'arf_show_full_screen_popup' ,'arf_hide_popup_loggedinuser', 'arf_hide_popup_on_mobile' ) ,
                            ),
                            'onload'      => array(
                                'fields'        => array( 'arf_background_overlay' , 'arf_size_width' ,  'arf_animation' , 'arf_show_full_screen_popup' ,'arf_hide_popup_loggedinuser', 'arf_hide_popup_on_mobile', 'arf_overlay_color' ) ,
                            ),
                            'scroll'      => array(
                                'fields'        => array( 'arf_scroll_percentage' , 'arf_background_overlay' , 'arf_overlay_color'  , 'arf_size_width' ,'arf_animation' , 'arf_show_close_button' , 'arf_show_full_screen_popup' ,'arf_hide_popup_loggedinuser', 'arf_hide_popup_on_mobile') ,
                            ),
                            'timer'      => array(
                                'fields'        => array( 'arf_time_interval' , 'arf_background_overlay' , 'arf_overlay_color' , 'arf_size_width' ,'arf_animation' , 'arf_show_close_button' , 'arf_show_full_screen_popup' ,'arf_hide_popup_loggedinuser', 'arf_hide_popup_on_mobile') ,
                            ),
                            'on_exit'      => array(
                                'fields'        => array( 'arf_background_overlay' , 'arf_overlay_color' , 'arf_size_width' ,'arf_animation'  , 'arf_show_close_button' , 'arf_show_full_screen_popup' ,'arf_hide_popup_loggedinuser', 'arf_hide_popup_on_mobile') ,
                            ),
                            'on_idle'      => array(
                                'fields'        => array( 'arf_background_overlay' , 'arf_overlay_color' , 'arf_size_width' ,'arf_animation' , 'arf_inactive_minute', 'arf_show_close_button' , 'arf_show_full_screen_popup' ,'arf_hide_popup_loggedinuser', 'arf_hide_popup_on_mobile') ,
                            )  
                        )
                       
                    ),
                    'arf_click_type'   => array(
                        'type'          => 'select',
                        'label'         => __('CLICK TYPES', 'ARForms'),
                        'default'       => 'link',
                        'options'       => $arf_pro_beaver_builder->arf_get_click_type_assets(),
                        'toggle'        => array(
                            'link'      => array(
                                'fields'        => array( 'arf_caption' , 'arf_background_overlay' , 'arf_overlay_color' , 'arf_size_width' , 'arf_animation' ,'arf_show_close_button' ,'arf_show_full_screen_popup' , 'arf_hide_popup_loggedinuser', 'arf_hide_popup_on_mobile'),
                            ),
                            'button'    =>array(
                                'fields'        => array('arf_caption' , 'arf_background_overlay' , 'arf_overlay_color' , 'arf_size_width' , 'arf_animation' , 'arf_background_color' , 'arf_text_color','arf_show_close_button' ,'arf_show_full_screen_popup' , 'arf_hide_popup_loggedinuser', 'arf_hide_popup_on_mobile'),
                            ),
                            'image'     =>array(
                                'fields'        => array( 'arf_image_url' , 'arf_image_height' , 'arf_image_width' , 'arf_size_width' , 'arf_size_height' , 'arf_hide_popup_loggedinuser', 'arf_hide_popup_on_mobile')
                            ),
                            'sticky'     =>array(
                                'fields'        => array( 'arf_caption' , 'arf_size_height'  , 'arf_size_width' ,  'arf_background_color' , 'arf_text_color' , 'arf_link_position' , 'arf_hide_popup_loggedinuser', 'arf_hide_popup_on_mobile')
                            ),
                            'fly'     =>array(
                                'fields'        => array( 'arf_caption' ,  'arf_size_width',  'arf_background_color' , 'arf_text_color' , 'arf_link_position' ,'arf_button_angle' , 'arf_hide_popup_loggedinuser', 'arf_hide_popup_on_mobile')
                            ),
                        )
                    ),
                    'arf_scroll_percentage' => array(
                        'type'          => 'text',
                        'label'         => __( 'OPEN POPUP WHEN USER SCROLL % OF PAGE AFTER PAGE LOAD', 'ARForms' ),
                        'default'       => '10',
                    ),
                    'arf_time_interval' => array(
                        'type'          => 'text',
                        'label'         => __( 'OPEN POPUP AFTER TIME INTERVAL OF', 'ARForms' ),
                        'default'       => '0',
                    ),
                    'arf_caption' => array(
                        'type'          => 'text',
                        'label'         => __( 'CAPTION', 'ARForms' ),
                        'default'       => 'Click here to open Form',
                    ),
                    'arf_background_overlay'   => array(
                        'type'          => 'select',
                        'label'         => __('BACKGROUND OVERLAY', 'ARForms'),
                        'default'       => '0.6',
                        'options'       => $arf_pro_beaver_builder->arf_get_overlay_assets(),
                    ),
                    'arf_overlay_color' => array(
                        'type'          => 'color',
                        'label'         => __( 'Overlay Color', 'ARForms' ),
                        'default'       => '333333',
                        'show_reset'    => true,
                        'show_alpha'    => true
                    ),
                    'arf_show_close_button' => array(
                        'type'    => 'button-group',
                        'label'   => __( 'Show Close Button', 'ARForms' ),
                        'default' => 'yes',
                        'options' => array(
                            'yes'    => __( 'Yes', 'ARForms' ),
                            'no'     => __( 'No', 'ARForms' ),
                        ),
                    ),
                    'arf_image_url' => array(
                        'type'          => 'text',
                        'label'         => __( 'IMAGE URL:', 'ARForms' ),
                    ),
                    'arf_image_height' => array(
                        'type'          => 'text',
                        'label'         => __( 'IMAGE SIZE [ HEIGHT ]:', 'ARForms' ),
                        'default'       => 'auto',
                    ),
                    'arf_image_width' => array(
                        'type'          => 'text',
                        'label'         => __( 'IMAGE SIZE [ WIDTH ]:', 'ARForms' ),
                        'default'       => 'auto',
                    ),
                    'arf_size_height' => array(
                        'type'          => 'text',
                        'label'         => __( 'SIZE [ HEIGHT ]:', 'ARForms' ),
                        'default'       => 'auto',
                    ),
                    'arf_size_width' => array(
                        'type'          => 'text',
                        'label'         => __( 'SIZE [ WIDTH (FORM WIDTH WILL BE OVERWRITTEN) ] :', 'ARForms' ),
                        'default'       => '800',
                    ),
                    'arf_background_color' => array(
                        'type'          => 'color',
                        'label'         => __( 'Background Color', 'ARForms' ),
                        'default'       => '333333',
                        'show_reset'    => true,
                        'show_alpha'    => true
                    ),
                    'arf_text_color' => array(
                        'type'          => 'color',
                        'label'         => __( 'Text Color', 'ARForms' ),
                        'default'       => '333333',
                        'show_reset'    => true,
                        'show_alpha'    => true
                    ),
                    'arf_show_full_screen_popup' => array(
                        'type'    => 'button-group',
                        'label'   => __( 'Show Full Screen Popup', 'ARForms' ),
                        'default' => 'no',
                        'options' => array(
                            'yes'    => __( 'Yes', 'ARForms' ),
                            'no'     => __( 'No', 'ARForms' ),
                        ),
                    ),
                    'arf_animation'   => array(
                        'type'          => 'select',
                        'label'         => __('ANIMATION EFFECT', 'ARForms'),
                        'default'       => 'no_animation',
                        'options'       => $arf_pro_beaver_builder->arf_get_animation_assets(),
                    ),
                    'arf_link_position'   => array(
                        'type'          => 'select',
                        'label'         => __('LINK POSITION?', 'ARForms'),
                        'default'       => 'top',
                        'options'       => $arf_pro_beaver_builder->arf_get_link_position_assets(),
                    ),
                    'arf_button_angle'   => array(
                        'type'          => 'select',
                        'label'         => __('BUTTON ANGLE', 'ARForms'),
                        'default'       => '0',
                        'options'       => $arf_pro_beaver_builder->arf_get_button_angle_assets(),
                    ),
                    'arf_hide_popup_loggedinuser' => array(
                        'type'    => 'button-group',
                        'label'   => __( 'Hide popup for Logged in User', 'ARForms' ),
                        'default' => 'no',
                        'options' => array(
                            'yes'    => __( 'Yes', 'ARForms' ),
                            'no'     => __( 'No', 'ARForms' ),
                        ),
                    ),
                    'arf_hide_popup_on_mobile' => array(
                        'type'    => 'button-group',
                        'label'   => __( 'Hide popup on Mobile Device', 'ARForms' ),
                        'default' => 'no',
                        'options' => array(
                            'yes'    => __( 'Yes', 'ARForms' ),
                            'no'     => __( 'No', 'ARForms' ),
                        ),
                    ),
                    'arf_inactive_minute' => array(
                        'type'          => 'text',
                        'label'         => __( 'SHOW AFTER USER IS INACTIVE FOR:', 'ARForms' ),
                        'default'       => '1',
                    ),
                )
            )
        )
    )
));