<?php
global $arf_post_value_class;
$arf_post_value_class = new arf_post_value();

class arf_post_value {
    function __construct() {

        add_action('arf_option_before_submit_conditional_logic', array($this, 'arf_post_values_after_redirect_to_url_html'), 11, 2);

        add_action('arfaftercreateentry', array($this, 'arf_after_submit_form'), 101, 2);

        add_action('arf_after_paypal_successful_paymnet', array($this, 'arf_after_submit_form_paypal'), 10, 3);

        add_action('arf_user_register', array( $this, 'arf_post_data_to_webhook_after_register' ), 10, 4 );

    }

    function arf_post_data_to_webhook_after_register( $user, $form_data, $form_id, $entry_id ){
        if (!$entry_id || !$form_id)
            return;

        $this->arf_after_submit_form($entry_id, $form_id);
    }

    /* Display html for show post values settings */
    function arf_post_values_after_redirect_to_url_html($id, $values){

        global $arfieldhelper, $arformcontroller;
        ?>
        <div class="arf_submit_action_post_values_container">
            <div class="arf_submit_action_post_values_inner_container">
                <div class="arf_submit_action_post_values_enable">
                    <div class="arf_popup_checkbox_wrapper" style="margin-top:5px;">
                        <div class="arf_custom_checkbox_div" style="margin-top: 4px;">
                            <div class="arf_custom_checkbox_wrapper">
                                <input type="checkbox" class="arf_enable_disable_post_values" name="options[arf_show_post_value]" id="arf_show_post_value" value="1" <?php isset($values['arf_show_post_value']) ? checked($values['arf_show_post_value'], 1) : ''; ?> />
                                <svg width="18px" height="18px">
                                    <?php echo ARF_CUSTOM_UNCHECKED_ICON; ?>
                                    <?php echo ARF_CUSTOM_CHECKED_ICON; ?>
                                </svg>
                            </div>
                            <span>
                                <label for="arf_show_post_value" style="margin-left: 4px;"><?php echo esc_html__('Send Form Data internaly to Custom URL', 'ARForms'); ?> (<?php echo esc_html__('Webhook','ARForms'); ?>)</label>
                            </span>
                        </div>
                    </div>
                    <?php
                    $arf_post_values_style = 'display: none;';
                    if (isset($values['arf_show_post_value']) && $values['arf_show_post_value'] == 1) {
                        $arf_post_values_style = '';
                    }
                    ?>
                    <span class="arf_submit_action_post_values_inner_block" style="padding-top: 0px;padding-bottom: 0px;font-style: italic;<?php echo $arf_post_values_style; ?>">
                    <?php echo esc_html__('(Upon successful submission form entry data will be sent to below mentioned url using POST method.)','ARForms');?></span>
                </div>
                <?php
                $arf_post_values_style = 'display: none;';
                if (isset($values['arf_show_post_value']) && $values['arf_show_post_value'] == 1) {
                    $arf_post_values_style = '';
                }
                ?>
                <div class="arf_submit_action_post_values_inner_block arfmarginl15" style="<?php echo $arf_post_values_style; ?>">
                    <label for="arf_post_value_url" class="arf_dropdown_autoresponder_label"><?php echo esc_html__('Enter URL to Submit Data', 'ARForms'); ?></label>
                    <input type="text" id="arf_post_value_url" class="arf_large_input_box arf_post_values_url arf_post_values_url_width" name="options[arf_post_value_url]" value="<?php echo isset($values['arf_post_value_url']) ? $values['arf_post_value_url'] : ''; ?>" />
                    <span class="arferrmessage" id="arf_post_value_url_error"><?php echo addslashes(esc_html__('This field cannot be blank','ARForms')); ?></span>
                    <span class="arferrmessage" id="arf_post_value_url_zapier_error" style="display:none;"><?php echo addslashes(esc_html__('Please use dedicated addon for Zapier.','ARForms')); ?></span>
                    <span class="arferrmessage" id="arf_post_value_url_pabbly_error" style="display:none;"><?php echo addslashes(esc_html__('Please use dedicated addon for Pabbly Connect.','ARForms')); ?></span>
                    <i class="arf_notes" style="float: left;width: 100%;"><?php echo esc_html__('Please insert url with http:// or https://.', 'ARForms'); ?></i>
                </div>
                <div id="arf_field_list_name_webhook" class="arf_submit_action_options arf_field_list_name_webhook" style="<?php echo(is_rtl())?'margin-right: -20px':''; echo (isset($values['arf_post_value_url']) && !empty($values['arf_post_value_url'])) ? 'display: block;':'display: none;'; ?>">
                    <?php
                    global $conditional_logic_array_if;
                    $act_exclude = array('divider', 'section', 'break', 'captcha', 'imagecontrol', 'confirm_email', 'confirm_password', 'signature', 'arf_repeater');
                    $arf_url_field_list_option = "";
                    if (!empty($values['fields'])) {      

                        foreach ($values['fields'] as $val_key => $fo) {

                            /* reputelog - please check this condition */
                            if($fo['type'] == 'arfslider' && $fo['arf_range_selector'] == 1) {
                                continue;
                            }

                            if ($fo['type'] == 'html' && isset( $fo['enable_total'] ) && $fo['enable_total'] == 0) {
                                continue;
                            }

                            if( isset( $fo['type2'] )  && 'ccfield' == $fo['type2'] ){
                                continue;
                            }

                            if(!in_array($fo['type'], $conditional_logic_array_if)){
                                
                                $current_field_id = $fo["id"];
                                $arf_field_key_name = isset($values['arf_field_key_name_webhook'])?arf_json_decode($values['arf_field_key_name_webhook'], true):'';
                                $post_selected_fields = isset($values["arf_select_post_fields_webhook"]) ? arf_json_decode($values['arf_select_post_fields_webhook'], true) : '';

                                if(!empty($arf_field_key_name)) {
                                    $arf_field_key_name_input = '';
                                    foreach ($arf_field_key_name as $key => $value) {
                                        if ($key == $current_field_id ) {
                                            $arf_field_key_name_input = isset($value) ? $value :'item_meta_'.$current_field_id;
                                        }
                                    }
                                    $post_selected_fields_input = '';
                                    foreach ($post_selected_fields as $key1 => $value1) {
                                        if ($key1 == $current_field_id ) {
                                            $post_selected_fields_input = isset($value1) ? $value1 :'';
                                        }
                                    }    

                                    $arf_url_field_list_option .=  '<div class="arf_set_url_fields_webhook"><div class="arf_url_field_list"><div class="arf_custom_checkbox_wrapper arf_select_post_fields"><input type="checkbox" name="options[arf_select_post_fields_webhook]['.$current_field_id.']" id="redirect_field_list_webhook_'.$current_field_id.'" '. checked( $post_selected_fields_input, 1, false ) .' value="1" /><svg width="18px" height="18px">'. ARF_CUSTOM_UNCHECKED_ICON.' '.ARF_CUSTOM_CHECKED_ICON.'</svg></div><label id="redirect_field_list_webhook_'.$current_field_id.'" class="arf_selectbox_option" for="redirect_field_list_webhook_'.$current_field_id.'">'.$arfieldhelper->arf_execute_function($fo["name"],'strip_tags').'</label></div><div class="arf_url_field_list" ><input type="text" name="options[arf_data_with_url_data_webhook]['.$current_field_id.']" id="arf_field_key_name_webhook_'.$current_field_id.'" value="'.$arf_field_key_name_input.'"></div></div>'; 
                                    
                                } else {

                                    if(!empty($field_key_nm)) {
                                        
                                        foreach ($field_key_nm as $key => $value) {
                                            if ($key == $current_field_id ) {
                                                $arf_field_key_name = isset($value) ? $value :'item_meta_'.$current_field_id;
                                            }
                                        }

                                        foreach ($post_selected_fields as $key1 => $value1) {
                                            if ($key1 == $current_field_id ) {
                                                $post_selected_fields = isset($value1) ? $value1 :'';
                                            }
                                        }
                                        
                                        $arf_url_field_list_option .=  '<div class="arf_set_url_fields_webhook"><div class="arf_url_field_list"><div class="arf_custom_checkbox_wrapper arf_select_post_fields"><input type="checkbox" name="options[arf_select_post_fields_webhook]['.$current_field_id.']" id="redirect_field_list_webhook_'.$current_field_id.'" value="1" '. checked( $post_selected_fields, 1, false ) .' /><svg width="18px" height="18px">'. ARF_CUSTOM_UNCHECKED_ICON.' '.ARF_CUSTOM_CHECKED_ICON.'</svg></div><label for="redirect_field_list_webhook_'.$current_field_id.'" id="redirect_field_list_webhook_'.$current_field_id.'" class="arf_selectbox_option">'.$arfieldhelper->arf_execute_function($fo["name"],'strip_tags').'</label></div><div class="arf_url_field_list" ><input  type="text" name="options[arf_data_with_url_data_webhook]['.$current_field_id.']" id="arf_field_key_name_webhook_'.$current_field_id.'" value="'.$arf_field_key_name.'"></div></div>'; 
                                    }
                                }

                            }
                            
                        }
                    }?>
                    <div>
                        <div class="arf_url_field_list_label" id="arfkflist">
                            <label class="arftitle_p" style="padding-left: 40px;">Fields</label>
                        </div>
                        <div class="arf_url_field_list_label" >
                            <label class="arftitle_p">Fields Key</label>
                        </div>
                        <?php echo $arf_url_field_list_option; ?>
                    </div>
                </div> 
            </div>
      </div>
      <?php
    }

    function arf_after_submit_form_paypal($form_id, $entry_id, $txn_id) {
        if (!$entry_id || !$form_id)
            return;

        $this->arf_after_submit_form($entry_id, $form_id);

    }


    function arf_after_submit_form($entry_id, $form_id) {

        global $arfrecordmeta, $wpdb, $arfform, $MdlDb;

        $ar_form = $arfform->getOne($form_id);

        $options = ($ar_form != '' && isset($ar_form->options)) ? $ar_form->options : array();

        if (isset($options['arf_show_post_value']) && $options['arf_show_post_value'] == 1) {

            if (isset($options['arf_post_value_url']) && $options['arf_post_value_url'] != '') {

                $arf_field_key_name = isset($options['arf_field_key_name_webhook']) ? $options['arf_field_key_name_webhook'] : "";
                $arf_field_key_name_arr = json_decode($arf_field_key_name,true);

                $arf_select_post_fields = isset($options['arf_select_post_fields_webhook']) ? $options['arf_select_post_fields_webhook'] : "";
                $arf_select_post_fields_arr = json_decode($arf_select_post_fields,true);

                $arposturl = $options['arf_post_value_url'];

                $entry_ids = array($entry_id);
                $values = $arfrecordmeta->getAll("it.field_id != 0 and it.entry_id in (" . implode(',', $entry_ids) . ")", " ORDER BY fi.id");
                if (!isset($uploads) or ! isset($uploads['baseurl'])) {
                    $uploads = wp_upload_dir();
                }

                $request_string = array();

                foreach($values as $key => $value) {

                    foreach($arf_field_key_name_arr as $arr => $val) {
                        
                        foreach($arf_select_post_fields_arr as $post_fields_arr => $post_fields_val) {

                            if(isset($value->field_id)){
                                if($arr == $value->field_id && $value->field_id == $post_fields_arr  && $post_fields_val == 1){

                                    if( isset($value->field_type) && $value->field_type != '' && $value->field_id != '' ){
                
                                        if( $this->arf_has_repeater_field( $value->field_id ) ){
                                            $request_string[$val] = array();
                                            if( $value->field_type == 'checkbox' ){
                                                $fvalues = explode( '[ARF_JOIN]', $value->entry_value);
                                                $n = 0;
                                                foreach( $fvalues as $fval ){
                                                    $fval_arr = explode('!|!',$fval);
                                                    $checked_val = $fval_arr[0];
                                                    $fchk_val = arf_json_decode( $fval_arr[0] );
                                                    if( !isset( $request_string[$val][$n] ) ){
                                                        $request_string[$val][$n] = array();
                                                    }
                                                    $request_string[$val][$n] = $fchk_val;
                                                    $n++;
                                                }
                                            } else {
                                                $request_string[$val] = explode('[ARF_JOIN]', $value->entry_value);
                                            }
                                        } else {
                                            if ($value->field_type == 'file') {
                
                                                $attach_file_values = explode('|', $value->entry_value);
                
                                                $arf_uploaded_files = "";
                
                                                foreach ($attach_file_values as $attach_file_val){
                
                                                    if($attach_file_val != "") {
                
                                                        $meta_field = $wpdb->get_row($wpdb->prepare("select `meta_value` from " . $wpdb->prefix . "postmeta where post_id = %d AND meta_key = '_wp_attached_file'",$attach_file_val)); //phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- Reason: $MdlDb->prefix is table name defined globally. False Positive alarm 
                                                        if( $meta_field ) {
                                                            $file = $meta_field->meta_value;
                                                            if ($file) {
                                                                $file = str_replace('thumbs/', '', $file);
                                                                $arf_uploaded_files .= $file.'|';
                                                            }
                                                        }
                                                    }
                                                }
                
                                                if ($arf_uploaded_files != "") {
                                                    $arf_uploaded_files = rtrim($arf_uploaded_files, "|");
                                                    $request_string[$val] = $arf_uploaded_files;
                                                }
                                            } else {
                                                if( $value->field_type == 'checkbox' || $value->field_type == 'arf_multiselect' ){

                                                    $request_string[$val] = arf_json_decode( $value->entry_value, true );
                                                } else if( $value->field_type == 'matrix' ){

                                                    $field_opts = $arfform->arf_select_db_data(true, '', $MdlDb->fields, 'field_options', 'WHERE id = %d', array( $value->field_id ), '', '', '', false, true );
                                                    $fopts = arf_json_decode( $field_opts->field_options, true );

                                                    $rows = $fopts['rows'];
                                                    $field_value = arf_json_decode( $value->entry_value, true );
                                                    $final_field_value = array();
                                                    foreach( $rows as $k => $value ){
                                                        if( !empty( $field_value[$k] ) ){
                                                            $final_field_value[$k] = $field_value[$k];
                                                        } else {
                                                            $final_field_value[$k] = '';
                                                        }
                                                    }
                                                    $request_string[$val] = $final_field_value;
                                                } else {
                                                        $request_string[$val] = $value->entry_value;
                                                    }
                                            }
                                        }
                                    }
                                }
                            }
                        }                        
                    }
                }
                    $arf_posts = array(
                        'method' => 'POST',
                        'timeout' => 5000,
                        'body' => $request_string,    
                    );      
                    
                    $raw_response = wp_remote_post($arposturl, $arf_posts);
                    
                }
        }
    }

    function arf_has_repeater_field( $field_id ){
        global $wpdb, $MdlDb;

        if( '' == $field_id || !isset( $field_id )){
            return false;
        }

        $field_data = $wpdb->get_row( $wpdb->prepare( "SELECT field_options FROM `".$MdlDb->fields."` WHERE id = %d", $field_id ) ); //phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- Reason: $MdlDb->fields is table name defined globally. False Positive alarm

        if( !empty( $field_data ) ){
            $field_opt = arf_json_decode( $field_data->field_options, true );

            if( isset( $field_opt['parent_field_type'] ) && 'arf_repeater' == $field_opt['parent_field_type'] ){
                return true;
            }
        }
        return false;
    }
}

?>