<?php

class arforms_pro_settings{

    var $setvaltolic;
    var $error_message;

    function __construct(){
    
        add_action( 'wp_ajax_arf_save_autoresponder_settings', array( $this, 'arforms_save_autoresponder_settings' ) );

        add_filter( 'plugin_action_links_arforms-form-builder/arforms-form-builder.php', array( $this, 'arforms_remove_deactivation_links' ) );

        add_action( 'admin_enqueue_scripts', array( $this, 'arforms_add_plugin_dependency' ) );

        add_action( 'wp_ajax_arf_gmail_remove_auth', array( $this, 'arf_gmail_remove_auth_func' ), 1 );

        
        add_action( 'admin_init', array( $this, 'arforms_create_additional_files'));
    }

    function arforms_create_additional_files(){

        if( !function_exists('WP_Filesystem' ) ){
            require_once(ABSPATH . 'wp-admin/includes/file.php');
        }

        WP_Filesystem();
        global $wp_filesystem;

        $arf_file = 'index.php';
        $file_content = '<?php /* silence is golden */';

        $wp_upload_dir = wp_upload_dir();
        $imageupload_dir = $wp_upload_dir['basedir'] . '/arforms/userfiles/';
        $imageupload_dir_sub = $wp_upload_dir['basedir'] . '/arforms/userfiles/thumbs/';
        $import_preset_value = $wp_upload_dir['basedir'] . '/arforms/import_preset_value/';

        if (!is_dir($import_preset_value)){
            wp_mkdir_p($import_preset_value);
        }

        $arf_imageuploadindex_file = $imageupload_dir.$arf_file;

        if( is_dir($imageupload_dir) && !file_exists( $arf_imageuploadindex_file ) ){
            if( '' == $file_content || ! $wp_filesystem->put_contents( $arf_imageuploadindex_file, $file_content, 0755 ) ){
                $this->error_message = esc_html__( "There is an issue while uploading a file. Please try again", "ARForms");
                //return false;
            }
        }

        $arf_imagesubuploadindex_file = $imageupload_dir_sub.$arf_file;

        if( is_dir($imageupload_dir_sub) && !file_exists( $arf_imagesubuploadindex_file ) ){
            if('' == $file_content || ! $wp_filesystem->put_contents($arf_imagesubuploadindex_file, $file_content, 0755)){
                $this->error_message = esc_html__("There is an issue while uploading a file. Please try again", 'ARForms');
                //return false;
            }
        }

        $arf_import_val_file = $import_preset_value.$arf_file;

        if( is_dir($import_preset_value) && !file_exists( $arf_import_val_file ) ){
            if( '' == $file_content || ! $wp_filesystem->put_contents($arf_import_val_file, $file_content, 0755)){
                $this->error_message = esc_html__("There is an issue while uploading a file. Please try again",'ARForms');
            }
        }

        $arf_arforms_dir = $wp_upload_dir['basedir'] . '/arforms/';
        $arforms_index_file = $arf_arforms_dir.$arf_file;

        if( is_dir($arf_arforms_dir) && !file_exists( $arforms_index_file ) ){
            if( '' == $file_content || ! $wp_filesystem->put_contents($arforms_index_file, $file_content, 0755)){
                $this->error_message = esc_html__("There is an issue while uploading a file. Please try again",'ARForms');
            }
        }

        $arf_maincss_dir = $wp_upload_dir['basedir'].'/arforms/maincss/';
        $arforms_index_maincss_file = $arf_maincss_dir.$arf_file;

        if( is_dir($arf_maincss_dir) && !file_exists( $arforms_index_maincss_file ) ){
            if('' == $file_content || !$wp_filesystem->put_contents($arforms_index_maincss_file, $file_content, 0755)){
                $this->error_message = esc_html__("There is an issue while uploading a file. Please try again",'ARForms');
            }
        }

        $arf_css_dir = $wp_upload_dir['basedir'].'/arforms/css/';
        $arforms_index_css_file = $arf_css_dir.$arf_file;

        if( is_dir($arf_css_dir) && !file_exists( $arforms_index_css_file ) ){
            if('' == $file_content || !$wp_filesystem->put_contents($arforms_index_css_file, $file_content, 0755)){
                $this->error_message = esc_html__("There is an issue while uploading a file. Please try again",'ARForms');
            }
        }
    }
    function arf_gmail_remove_auth_func(){
        global $arformsmain;
		if ( empty( $_POST['_wpnonce_arfnonce'] ) || ( isset( $_POST['_wpnonce_arfnonce'] ) && '' != $_POST['_wpnonce_arfnonce'] && ! wp_verify_nonce( sanitize_text_field( $_POST['_wpnonce_arfnonce'] ), 'arflite_wp_nonce' ) ) ) {
            $response_data['status'] = 'error';
            $response_data['message'] = esc_html__( 'Sorry, your request cannot be processed due to security reason.','ARForms' );
            echo json_encode($response_data);
            die;
		}

        if( !current_user_can( 'arfchangesettings') ){
            $response_data['status'] = 'error';
            $response_data['message'] = esc_html__( 'Sorry, you do not have permission to perform this action','ARForms' );
            echo json_encode($response_data);
            die;
        }

        $auth_token = !empty( $_POST['auth_token'] ) ? sanitize_text_field( $_POST['auth_token'] ) : '' ; //phpcs:ignore WordPress.Security.NonceVerification
        $auth_email = !empty( $_POST['connected_email']) ? sanitize_text_field( $_POST['connected_email']) : ''; //phpcs:ignore WordPress.Security.NonceVerification
        $auth_response = !empty( $_POST['access_token_data']) ? $_POST['access_token_data'] : ''; //phpcs:ignore
        if( !empty( $auth_response)){
			$arformsmain->arforms_update_settings( 'arf_gmail_api_response_data', '', 'general_settings' );
        }
        if( !empty( $auth_token)){
			$arformsmain->arforms_update_settings( 'arf_gmail_api_access_token', '', 'general_settings' );
        }
        if( !empty( $auth_email )){
			$arformsmain->arforms_update_settings( 'arf_gmail_api_connected_email', '', 'general_settings' );
        }
        $response['variant'] = 'success';
        $response['title']   = esc_html__( 'Success', 'ARForms' );
        $response['msg']     = esc_html__( 'Sign out successfully.', 'ARForms' );
        echo wp_json_encode( $response );
        die();
    }

    function arforms_add_plugin_dependency(){

        global $pagenow, $arfversion;
        
        if( 'plugins.php' == $pagenow ){
            wp_register_script( 'arforms-dependency', ARFURL . '/js/arforms-dependency.js', array( 'jquery' ), $arfversion );
            wp_enqueue_script( 'arforms-dependency' );
        }

    }

    function arforms_remove_deactivation_links(  $links ){

        if( isset( $links['deactivate'] ) ){
			unset( $links['deactivate'] );
		}

        $required_note = esc_html__('Required by ARForms - Premium', 'ARForms' );

        array_unshift( $links, '<label class="arforms-pro-notice-plugin-label">'.$required_note.'</label>' );

        return $links;
    }

    function arforms_save_autoresponder_settings(){
        global $wpdb, $MdlDb, $arformsmain;

        $response = array();

        if ( empty( $_POST['_wpnonce_arfnonce'] ) || ( '' != $_POST['_wpnonce_arfnonce']  && ! wp_verify_nonce( sanitize_text_field( $_POST['_wpnonce_arfnonce'] ) , 'arflite_wp_nonce' ) ) ) {
            echo json_encode(array('error' => 'false', 'msg' => addslashes(esc_html__('Sorry, your request cannot be processed due to security reason.', 'ARForms'))));
            die;
           
		}

        if( !current_user_can( 'arfchangesettings' ) ){
            $response_data = array();
			$response_data['error'] = true;
			$response_data['message'] = esc_html__( 'Sorry, you do not have permission to perform this action', 'ARForms' );
			echo json_encode($response_data);
			die;
		}

        $response['variant'] = 'error';
        $response['title']   = esc_html__('Error', 'ARForms');
        $response['msg']     = esc_html__('Something Went wrong while updating settings...', 'ARForms');
        
        $arf_setting_filterd_form = isset( $_POST['setting_form_data'] ) ?  stripslashes_deep( $_POST['setting_form_data'] ) : array(); //phpcs:ignore
		/* $str = json_decode( stripslashes_deep( $arf_setting_filterd_form ), true );; */
		$settings_data = json_decode( $arf_setting_filterd_form, true );

        if (isset($settings_data['mailchimp_type']) && $settings_data['mailchimp_type'] == 1) {
            $arf_mailchimp_api = isset($settings_data['mailchimp_api']) ? $settings_data['mailchimp_api'] : '';
            $arf_mailchimp_listid = isset($settings_data['mailchimp_listid']) ? $settings_data['mailchimp_listid'] : '';
            $wpdb->update($MdlDb->autoresponder, array('responder_api_key' => $arf_mailchimp_api, 'responder_list' => $arf_mailchimp_listid), array('responder_id' => '1'));
        } else {
            $arf_mailchimp_webform = isset($settings_data['mailchimp_web_form']) ? $settings_data['mailchimp_web_form'] : '';
            $wpdb->update($MdlDb->autoresponder, array('responder_web_form' => $arf_mailchimp_webform), array('responder_id' => '1'));
        }

        if (isset($settings_data['aweber_type']) && $settings_data['aweber_type'] == 1) {
            $arf_aweber_api = !empty( $settings_data['aweber_oauth_code'] ) ? $settings_data['aweber_oauth_code'] : '';
            $awe_responder_list = isset($settings_data['responder_list']) ? $settings_data['responder_list'] : '';
            $wpdb->update($MdlDb->autoresponder, array( 'responder_api_key' => $arf_aweber_api, 'responder_list' => $awe_responder_list), array('responder_id' => '3'));
        } else {
            $arf_aweber_webform = isset($settings_data['aweber_web_form']) ? $settings_data['aweber_web_form'] : '';
            $wpdb->update($MdlDb->autoresponder, array('responder_web_form' => $arf_aweber_webform), array('responder_id' => '3'));
        }

        if (isset($settings_data['getresponse_type']) && $settings_data['getresponse_type'] == 1) {
            $arf_getresponse_api = isset($settings_data['getresponse_api']) ? $settings_data['getresponse_api'] : '';
            $arf_getresponse_list_id = isset($settings_data['getresponse_listid']) ? $settings_data['getresponse_listid'] : '';
            $wpdb->update($MdlDb->autoresponder, array('responder_api_key' => $arf_getresponse_api, 'responder_list_id' => $arf_getresponse_list_id), array('responder_id' => '4'));
        } else {
            $arf_getresponse_webform = isset($settings_data['getresponse_web_form']) ? $settings_data['getresponse_web_form'] : '';
            $wpdb->update($MdlDb->autoresponder, array('responder_web_form' => $arf_getresponse_webform), array('responder_id' => '4'));
        }

        if (isset($settings_data['icontact_type']) && $settings_data['icontact_type'] == 1) {
            $arf_icontact_api = isset($settings_data['icontact_api']) ? $settings_data['icontact_api'] : '';
            $arf_icontact_username = isset($settings_data['icontact_username']) ? $settings_data['icontact_username'] : "";
            $arf_icontact_password = isset($settings_data['icontact_password']) ? $settings_data['icontact_password'] : '';
            $arf_icontact_listname = isset($settings_data['icontact_listname']) ? $settings_data['icontact_listname'] : '';

            $wpdb->update($MdlDb->autoresponder, array('responder_api_key' => $arf_icontact_api, 'responder_username' => $arf_icontact_username, 'responder_password' => $arf_icontact_password, 'responder_list' => $arf_icontact_listname), array('responder_id' => '8'));
        } else {
            $arf_icontact_webform = isset($settings_data['icontact_web_form']) ? $settings_data['icontact_web_form'] : '';
            $wpdb->update($MdlDb->autoresponder, array('responder_web_form' => $arf_icontact_webform), array('responder_id' => '8'));
        }


        if (isset($settings_data['constant_type']) && $settings_data['constant_type'] == 1) {
            $arf_responder_api = isset($settings_data['constant_api']) ? $settings_data['constant_api'] : "";
            $arf_responder_token = isset($settings_data['constant_access_token']) ? $settings_data['constant_access_token'] : '';
            $arf_responder_list_id = isset($settings_data['constant_listname']) ? $settings_data['constant_listname'] : '';
            $wpdb->update($MdlDb->autoresponder, array('responder_api_key' => $arf_responder_api, 'responder_list_id' => $arf_responder_token, 'responder_list' => $arf_responder_list_id), array('responder_id' => '9'));
        } else {
            $arf_responder_webform = isset($settings_data['constant_web_form']) ? $settings_data['constant_web_form'] : '';
            $wpdb->update($MdlDb->autoresponder, array('responder_web_form' => $arf_responder_webform), array('responder_id' => '9'));
        }

        do_action('arf_autoresponder_out_side_email_marketing_tools_update', $settings_data);

        $arr = array(
            'aweber_type' => arf_sanitize_value($settings_data['aweber_type'], 'integer'),
            'mailchimp_type' => arf_sanitize_value($settings_data['mailchimp_type'], 'integer'),
            'getresponse_type' => arf_sanitize_value($settings_data['getresponse_type'], 'integer'),
            'icontact_type' => arf_sanitize_value($settings_data['icontact_type'], 'integer'),
            'constant_type' => arf_sanitize_value($settings_data['constant_type'], 'integer'),
        );

        $arr_new = $arr;

        update_option('arf_ar_type', $arr_new);

        update_option('arforms_current_tab', 'autoresponder_settings' );

        $response['variant'] = 'success';
        $response['title']   = esc_html__('Success', 'ARForms');
        $response['msg']     = esc_html__('Setting saved successfully.', 'ARForms');

        echo wp_json_encode( $response );
        die;
    }

    function initialize(){
        global $current_user, $arformcontroller, $maincontroller, $arforms_pro_settings;

        if( !empty( $arforms_pro_settings->setvaltolic) ) {
            return $arforms_pro_settings->setvaltolic;
        }

        global $arformcontroller,$arformsplugin;
        $setvaltolic = 0;
        $setvaltolic = $arformcontroller->$arformsplugin();

        $arforms_pro_settings->setvaltolic = $setvaltolic;
    }

    function arforms_get_licval(){
        return $this->setvaltolic;
    }

    public static function arforms_fetch_pro_default_options(){
        return array(
            'brand' => false,
            'affiliate_code' => 'reputeinfosystems',
            'decimal_separator' => '.',
            'arfdisplayfilesinwpmedia' => false,
            'arf_file_uplod_dir_path' => 'wp-content/uploads/arforms/userfiles/'
        );
    }

    public static function arforms_render_pro_settings_ui( $setting_tab ){
        global $arforms_pro_settings;
        $arforms_pro_settings->initialize();
        $render_func = $setting_tab.'_block';
        if( method_exists( $arforms_pro_settings, $render_func ) ){
            call_user_func( array( $arforms_pro_settings, $render_func ) );
        }

    }

    function arforms_pro_render_license_notice_block(){
        if( !$this->arforms_get_licval() ){
            $admin_css_url = admin_url('admin.php?page=ARForms-license');
            ?>
                <div style="margin-top:20px;margin-bottom:10px;border-left: 4px solid #ffba00;box-shadow: 0 1px 1px 0 rgba(0, 0, 0, 0.1);height:20px;width:99%;padding:10px 0px 10px 25px;background-color:#f2f2f2;color:#000000;font-size:17px;display:block;visibility:visible;text-align:left;" >ARForms License is not activated. Please activate license from <a href="<?php echo esc_url( $admin_css_url ); ?>">here</a></div>
            <?php
        }
    }

    function rebranding_block(){
        global $arfsettings;
        if( $this->arforms_get_licval() ){
            ?>
            <td class="tdclass" valign="top" style="padding-left:30px;"><label class="lblsubtitle"><?php echo esc_html__('Rebranding', 'ARForms'); ?></label> </td>

            <td valign="top" style="padding-bottom:10px;">
                <div class="arf_custom_checkbox_div">
                    <div class="arf_custom_checkbox_wrapper">
                        <input type="checkbox" name="frm_brand" id="frm_brand" value="1" <?php checked($arfsettings->brand, 1) ?> />
                        <svg width="18px" height="18px">
                        <?php echo ARF_CUSTOM_UNCHECKED_ICON; ?>
                        <?php echo ARF_CUSTOM_CHECKED_ICON; ?>
                        </svg>
                    </div>
                    <span style="margin-left: 5px;"><label for="frm_brand"><?php echo esc_html__('Remove rebranding link', 'ARForms'); ?></label></span>
                </div>
            </td>
            <?php
        }
    }

    function affiliate_code_block(){
        global $arfsettings;
        if( $this->arforms_get_licval() ){
            ?>
            <tr>
                <td class="tdclass" valign="top" style="padding-left:30px;"><label class="lblsubtitle"><?php echo esc_html__('Affiliate Code', 'ARForms'); ?></label> </td>
                <td valign="top" style="padding-bottom:10px;">
                    <input type="text" class="txtmodal1" id="affiliate_code" name="affiliate_code" value="<?php echo $arfsettings->affiliate_code; ?>" style="width:400px;">
                </td>
            </tr>
            <?php
        }
    }

    function decimal_separator_block(){
        global $arfsettings, $maincontroller;
        ?>
        <tr class="arfmainformfield" valign="top">
            <td class="tdclass">
                <label class="lblsubtitle"><?php echo addslashes(esc_html__('Decimal separator', 'ARForms')); ?></label>
            </td>
            <td style="padding-bottom:10px;">
                <?php
                $decimal_separator_options = array(
                    '.' => addslashes(esc_html__('Dot (.)', 'ARForms')),
                    ',' => addslashes(esc_html__('Comma (,)', 'ARForms')),
                    'no_separator' => addslashes(esc_html__('No Separator', 'ARForms'))
                );
                $selected_decimal_separator = '.';

                foreach ( $decimal_separator_options as $decimal_value => $decimal_name) {

                    if (isset($arfsettings->decimal_separator) && $arfsettings->decimal_separator == $decimal_value) {
                        $selected_decimal_separator = esc_attr($decimal_value);
                        $decimal_separator_options[esc_attr($decimal_value)] = $decimal_name;
                    }
                }
                ?>
                <div class="sltstandard" style="float:none;">
                    <?php
                        echo $maincontroller->arf_selectpicker_dom( 'decimal_separator', 'decimal_separator', '', 'width:229px;', $selected_decimal_separator, array(), $decimal_separator_options );
                    ?>
                </div>
            </td>
        </tr>
        <?php
    }

    function upload_file_in_wpmedia_block(){
        global $arfsettings;
        ?>
        <tr>
            <td class="tdclass" valign="top" style="padding-left:30px"><label class="lblsubtitle"><?php esc_html_e( 'Display uploaded files in WordPress media section', 'ARForms' ); ?></label></td>
            <td valign="top" style="position: relative; top:-10px;">
                <div class="arf_custom_checkbox_div">
                    <div class="arf_custom_checkbox_wrapper">
                        <input type="checkbox" name="arfdisplayfilesinwpmedia" id="arfdisplayfilesinwpmedia" value="1" <?php checked($arfsettings->arfdisplayfilesinwpmedia, 1) ?> />
                        <svg width="18px" height="18px">
                        <?php echo ARF_CUSTOM_UNCHECKED_ICON; ?>
                        <?php echo ARF_CUSTOM_CHECKED_ICON; ?>
                        </svg>
                    </div>
                    <span style="margin-left: 5px;"><label for="arfdisplayfilesinwpmedia"><?php echo esc_html__('Yes', 'ARForms'); ?></label></span>
                </div>
            </td>
        </tr>
        <?php
    }

    function upload_file_path_block(){
        global $arfsettings;
        ?>
        <tr>
            <td class="tdclass" valign="top" style="padding-left:30px;padding-top: 20px;vertical-align: top"><label class="lblsubtitle"><?php echo esc_html__('File Upload Path :', 'ARForms'); ?></label> </td>
            <td valign="top" style="padding-bottom:10px;padding-top: 20px;">
                <span><?php
                    if( false == get_transient( 'arf_hosted_on_wp' ) ){
                        echo ABSPATH;
                    } else {
                        $document_root = !empty( $_SERVER['DOCUMENT_ROOT']) ? sanitize_text_field( $_SERVER['DOCUMENT_ROOT']) : '';
                        echo $document_root; //phpcs:ignore
                    }
                ?></span>
                <input type="text" class="txtmodal1" id="arf_file_uplod_dir_path" name="arf_file_uplod_dir_path" value="<?php echo isset($arfsettings->arf_file_uplod_dir_path) ? $arfsettings->arf_file_uplod_dir_path : 'wp-content/uploads/arforms/userfiles'; ?>" style="width:400px;">
                <br/><br/>
                <span style="color:#f20000;"><?php esc_html_e('Recommended for advanced user only. Please make sure that the upload directory you have set is writable, otherwise file upload will not work.','ARForms'); ?></span>
                <br/><br/>
                <span>{form_id} : <?php esc_html_e('this shortcode will replace with the form id','ARForms'); ?> </span>
                <br/>
                <br/>
                <span>{year} : <?php esc_html_e('this shortcode will replace with current year.','ARForms'); ?></span>
                <br/>
                <br/>
                <span>{month} : <?php esc_html_e('this shortcode will replace with current month','ARForms'); ?></span>
                <br/>
                <br/>
                <span>{day} : <?php esc_html_e('this shortcode will replace with current day','ARForms'); ?></span>
            </td>
        </tr>
        <?php
    }

    function remove_junk_file_block(){
        ?>
            
        <?php
    }

    function remove_anaytics_view_data_block() {

           

        ?>
            
        <?php
    }

    function wipe_data_block() {
        
        global $wpdb, $MdlDb;

        $total_view_counter = $wpdb->get_var("SELECT COUNT(*) FROM ".$MdlDb->views);
    ?>
        <tr class="arfmainformfield" valign="top">
            <td colspan="2"><div class="dotted_line dottedline-width96"></div></td>
        </tr>
        <!-- WIPE DATA SECTION -->
        <tr class="arfmainformfield">
            <td valign="top" colspan="2" class="lbltitle titleclass"><?php echo esc_html__('Data Cleanup & Reset', 'ARForms'); ?></td>
        </tr>

        <tr>
            <td class="tdclass" valign="top" style="padding-left:30px;padding-top: 20px;vertical-align: top"><label class="lblsubtitle"><?php echo esc_html__('Remove junk files', 'ARForms'); ?></label> </td>
            <td valign="top" style="padding-bottom:10px;padding-top: 20px;">
                <input type="button" value="<?php echo addslashes(esc_html__('Remove', 'ARForms')); ?>" class="rounded_button arf_btn_dark_blue" id="arf_remove_junk_files"  style="<?php echo (is_rtl()) ? 'margin-right: -4px;' : 'margin-left: -4px;'; ?>color:#ffffff;width: 118px !important;float:left;">
                <div class="arf_imageloader" id="arf_remove_junk_files_loader" style="display:none;position:relative;left:10px;top:8px;"></div>
            </td>
        </tr>
        <div class="arf_modal_overlay">
            <div id="delete_junk_file_msg" class="arfmodal arfdeletemodabox arf_popup_container arfdeletemodalboxnew arfactive">
                <div class="arfdelete_modal_msg delete_confirm_message">
                    <?php echo esc_html__( 'Are you sure you want to perform this action?','ARForms').'<br/>'.esc_html__(' This action will remove all the junk files which are uploaded by user and not associated with any forms.', 'ARForms' ); ?>
                </div>
                <div class="arf_delete_modal_row delete_popup_footer">
                    <button type="button" class="rounded_button add_button arf_delete_modal_left arfdelete_color_red" onClick="arf_delete_junk_files();"><?php esc_html_e('Okay', 'ARForms'); ?></button>&nbsp;&nbsp;
                    <button type="button" class="arf_delete_modal_right rounded_button delete_button arfdelete_color_gray" onClick="jQuery('.arf_popup_container,.arf_modal_overlay').removeClass('arfactive');"><?php esc_html_e( 'Cancel', 'ARForms' ) ?></button>
                </div>
            </div>
        </div>

        <tr>
            <td class="tdclass" valign="top" style="padding-left:30px;padding-top: 10px;vertical-align: top"><label class="lblsubtitle"><?php echo esc_html__('Flush Visitor analytics data', 'ARForms'); ?></label> </td>
            <td valign="top" style="padding-bottom:10px;padding-top: 10px;">
                <input type="button" value="<?php echo addslashes(esc_html__('Clean up', 'ARForms')); ?>" class="rounded_button arf_btn_dark_blue" id="arf_visitor_anaytics_files"  style="<?php echo (is_rtl()) ? 'margin-right: -4px;' : 'margin-left: -4px;'; ?>color:#ffffff;width: 118px !important;float:left;"><span  class="lblnotetitle arf_remove_ananytics_data">(<?php echo addslashes(esc_html__('Total number of visitors '. $total_view_counter, 'ARForms')); ?>)</span>
                <div class="arf_imageloader" id="arf_remove_anaytics_files_loader" style="display:none;position:relative;left:2px;top:8px;"></div>
            </td>
        </tr>
        <div class="arf_modal_overlay">
            <div id="delete_visitor_anaytics_msg" class="arfmodal arfdeletemodabox arf_popup_container arfdeletemodalboxnew arfactive">
                <div class="arfdelete_modal_msg delete_confirm_message">
                    <?php echo esc_html__( 'Are you sure you want to perform this action?','ARForms').'<br/>'.esc_html__(' This action will remove all the visitor analytics data.', 'ARForms' ); ?>
                </div>
                <div class="arf_delete_modal_row delete_popup_footer">
                    <button type="button" class="rounded_button add_button arf_delete_modal_left arfdelete_color_red" onClick="arf_delete_view_analytics_files();"><?php esc_html_e('Okay', 'ARForms'); ?></button>&nbsp;&nbsp;
                    <button type="button" class="arf_delete_modal_right rounded_button delete_button arfdelete_color_gray" onClick="jQuery('.arf_popup_container,.arf_modal_overlay').removeClass('arfactive');"><?php esc_html_e( 'Cancel', 'ARForms' ) ?></button>
                </div>
            </div>
        </div>

        <tr>
            <td class="tdclass genenal-setlbl-padding arf_vertical_align_top" valign="top">
                <label class="lblsubtitle"><?php echo esc_html__('Reset Data Option', 'ARForms'); ?></label>
            </td>
            <td valign="top" class="email-setting-input-td">

                <div style="display: flex; align-items: center; gap: 10px;">

                    <div class="arf_selectpicker_wrapper" style="width:350px;">
                        <input type="text" autocomplete="off" class="arf-selectpicker-input-control" id="arflite_wipe_data_option" name="arflite_wipe_data_option" value="">

                        <dl class="arf-selectpicker-control" data-id="arflite_wipe_data_option" data-name="arflite_wipe_data_option">
                            <dt>
                                <span><?php echo esc_html__('Select an option to clean the data', 'ARForms'); ?></span>
                                <i class="arf-selectpicker-caret"></i>
                            </dt>
                            <dd>
                                <ul data-id="arflite_wipe_data_option">
                                    <li data-value="" data-label="<?php echo esc_attr__('Select an option to clean the data', 'ARForms'); ?>"><?php echo esc_html__('Select an option to clean the data', 'ARForms'); ?></li>
                                    <li data-value="wipe_entries_analysis" data-label="<?php echo esc_attr__('Reset Form Entries including analytics', 'ARForms'); ?>"><?php echo esc_html__('Reset Form Entries including analytics', 'ARForms'); ?></li>
                                    <li data-value="wipe_exclude_settings" data-label="<?php echo esc_attr__('Reset All Forms data exclude settings', 'ARForms'); ?>"><?php echo esc_html__('Reset All Forms data exclude settings', 'ARForms'); ?></li>
                                    <li data-value="wipe_all" data-label="<?php echo esc_attr__('Reset all data', 'ARForms'); ?>"><?php echo esc_html__('Reset all data', 'ARForms'); ?></li>
                                </ul>
                            </dd>
                        </dl>
                    </div>

                    <input type="button" value="<?php echo esc_attr__('Apply', 'ARForms'); ?>" class="rounded_button arf_btn_dark_blue" id="arflite_wipe_data_button" style="color:#ffffff; width: auto; padding: 0 15px; flex-shrink: 0;">
                    <div class="arf_imageloader" id="arflite_wipe_data_loader" style="display:none;position:relative;left:3px;top:2px;"></div>
                </div>

                <span class="lblsubtitle" style="color:#f20000; font-weight: bold;">
                    <?php echo esc_html__('Warning: This action is irreversible. Ensure your database is fully backed up before proceeding.', 'ARForms'); ?>
                </span>
            </td>
        </tr>

        <div class="arf_modal_overlay">
            <div id="arf_wipe_data_confirmation_modal" class="arfmodal arfdeletemodabox arf_popup_container arfdeletemodalboxnew">
                <div class="arfdelete_modal_msg delete_confirm_message">
                    <span id="arf_wipe_data_confirm_text" style="font-weight: normal;"></span>
                    <br/>
                    <?php echo esc_html__( 'Are you sure you want to perform this action?', 'ARForms' ); ?>
                </div>
                <div class="arf_delete_modal_row delete_popup_footer">
                    <button type="button" class="rounded_button add_button arf_delete_modal_left arfdelete_color_red" id="arf_confirm_wipe_button"><?php esc_html_e('Confirm', 'ARForms'); ?></button>&nbsp;&nbsp;
                    <button type="button" class="arf_delete_modal_right rounded_button delete_button arfdelete_color_gray" onClick="jQuery('.arf_popup_container,.arf_modal_overlay').removeClass('arfactive');"><?php esc_html_e( 'Cancel', 'ARForms' ) ?></button>
                </div>
            </div>
        </div>
    <?php
    }

    function support_help_icon_block(){
        ?>
        <a href="https://support.arpluginshop.com" target="_blank" class="arforms_help_link">
            <svg width="52" height="52" viewBox="0 0 70 70" fill="none" xmlns="http://www.w3.org/2000/svg" class="arf_main_help_icon_support arf_help_icon_data arfhelptip" title="<?php echo  esc_attr__('Technical Support', 'ARForms') ?>">
                <path d="M21.5695 48.433C22.0847 48.9482 22.6132 49.4235 23.1727 49.865C23.2915 49.9587 23.464 49.9471 23.5711 49.8401L29.9485 43.4628C30.0822 43.329 30.055 43.1129 29.8955 43.011C29.3236 42.6458 28.7838 42.2143 28.286 41.7166C27.8042 41.2348 27.3881 40.711 27.0278 40.1657C26.9244 40.0093 26.7098 39.985 26.5772 40.1176L20.2078 46.4869C20.0993 46.5954 20.0884 46.771 20.1845 46.8906C20.6146 47.4255 21.0724 47.9359 21.5695 48.433Z" fill="white"/>
                <path d="M44.2455 51.6012C44.4185 51.5046 44.4503 51.2635 44.3102 51.1235L37.4926 44.3059C37.4216 44.2349 37.3198 44.2075 37.2221 44.2307C35.7445 44.582 34.2126 44.5819 32.7423 44.2234C32.6442 44.1995 32.5418 44.2268 32.4704 44.2982L25.6613 51.1072C25.5214 51.2471 25.5529 51.4879 25.7256 51.5847C31.4611 54.7972 38.5022 54.8052 44.2455 51.6012Z" fill="white"/>
                <path d="M46.8072 49.8891C47.3752 49.4396 47.912 48.9561 48.4355 48.4325C48.9243 47.9437 49.3739 47.4418 49.7959 46.9153C49.8917 46.7957 49.8806 46.6203 49.7723 46.5119L43.4052 40.1449C43.2718 40.0115 43.0566 40.0382 42.954 40.1965C42.6049 40.7353 42.1916 41.2434 41.7189 41.7162C41.2133 42.2218 40.6652 42.661 40.0801 43.0286C39.9191 43.1298 39.8904 43.3466 40.0248 43.481L46.4084 49.8645C46.5156 49.9717 46.6883 49.9831 46.8072 49.8891Z" fill="white"/>
                <path d="M18.4499 44.3442C18.5469 44.5162 18.7872 44.5474 18.9269 44.4077L25.7274 37.6072C25.7994 37.5353 25.8265 37.4321 25.8017 37.3334C25.4272 35.8453 25.4122 34.2815 25.7706 32.7788C25.7939 32.6812 25.7665 32.5795 25.6956 32.5085L18.8777 25.6907C18.7377 25.5507 18.4966 25.5823 18.4 25.7552C15.1798 31.5164 15.2038 38.591 18.4499 44.3442Z" fill="white"/>
                <path d="M32.6257 25.8058C34.1714 25.4088 35.7995 25.4085 37.3379 25.7982C37.4365 25.8232 37.5396 25.7961 37.6115 25.7242L44.412 18.9238C44.5517 18.7841 44.5206 18.5437 44.3485 18.4466C38.5519 15.1763 31.4104 15.1845 25.6295 18.4713C25.4581 18.5688 25.4274 18.8086 25.5669 18.948L32.3511 25.7321C32.4232 25.8043 32.5269 25.8312 32.6257 25.8058Z" fill="white"/>
                <path d="M43.0136 29.8927C43.1155 30.0523 43.3317 30.0795 43.4654 29.9457L49.8428 23.5684C49.9499 23.4614 49.9615 23.2888 49.8677 23.17C49.0454 22.1277 48.0074 21.0775 46.8933 20.1818C46.7737 20.0857 46.5981 20.0967 46.4896 20.2051L40.1202 26.5745C39.9876 26.7071 40.0119 26.9217 40.1684 27.0251C41.316 27.7833 42.2704 28.7288 43.0136 29.8927Z" fill="white"/>
                <path d="M51.5885 25.7226C51.4918 25.5499 51.2509 25.5183 51.111 25.6583L44.302 32.4672C44.2306 32.5386 44.2035 32.6409 44.2275 32.7389C44.6011 34.2594 44.586 35.8555 44.1961 37.3761C44.1707 37.4751 44.1977 37.5789 44.2699 37.6512L51.0538 44.435C51.1933 44.5744 51.4332 44.5437 51.5306 44.3721C54.8011 38.6091 54.8255 31.5013 51.5885 25.7226Z" fill="white"/>
                <path d="M23.0869 20.207C21.9807 21.0935 20.9396 22.1512 20.1131 23.1956C20.0191 23.3145 20.0304 23.4873 20.1376 23.5944L26.5212 29.978C26.6557 30.1124 26.8725 30.0837 26.9736 29.9228C27.6884 28.7852 28.6936 27.7695 29.8057 27.0488C29.9641 26.9461 29.9908 26.7311 29.8574 26.5976L23.4903 20.2306C23.382 20.1223 23.2065 20.1111 23.0869 20.207Z" fill="white"/>
            </svg>
        </a>
        <?php
    }

    function arforms_render_additional_settings_block(){
        global $arfsettings;
        $setvaltolic = $this->arforms_get_licval();
        do_action('arf_outside_global_setting_block', $arfsettings, $setvaltolic);
    }
}

global $arforms_pro_settings;
$arforms_pro_settings = new arforms_pro_settings();