<?php

class arforms_pro_block_widget{

    public $attributes = array(
		'form_id' => array(
			'type' => "string"
        ),
        'trigger_type'  => array(
            'type' => 'string',
            'default' => 'onclick'
        ),
        'click_type'  => array(
            'type' => 'string',
            'default' => 'link'
        ),
        'show_close_button'  => array(
            'type' => 'boolean',
            'default' => true
        ),
        'animation_effect'  => array(
            'type' => 'string',
            'default' => 'no_animation'
        ),
        'background_overlay'  => array(
            'type' => 'string',
            'default' => '0.6'
        ),
        'background_overlay_colorpicker'  => array(
            'type' => 'string',
            'default' => '#000000'
        ),
        'hide_popup_loggedin_user'  => array(
            'type' => 'boolean',
            'default' => false
        ),
        'hide_popup_on_mobile'  => array(
            'type' => 'boolean',
            'default' => false
        ),
        'button_bg_color'  => array(
            'type' => 'string',
            'default' => '#8ccf7a'
        ),
        'button_text_color'  => array(
            'type' => 'string',
            'default' => '#ffffff'
        ),
        'is_show_full_screen_popup'  => array(
            'type' => 'boolean',
            'default' => false
        ),
        'caption'  => array(
            'type' => 'string',
        ),
        'size_width'  => array(
            'type' => 'string',
            'default' => '800'
        ),
        'size_height'  => array(
            'type' => 'string',
            'default' => 'auto'
        ),
        'image_url'  => array(
            'type' => 'string',
            'default' => ''
        ),
        'image_size_height'  => array(
            'type' => 'string',
            'default' => 'auto'
        ),
        'image_size_width'  => array(
            'type' => 'string',
            'default' => 'auto'
        ),
        'scroll_percentage'  => array(
            'type' => 'string',
            'default' => '10'
        ),
        'popup_time'  => array(
            'type' => 'string',
            'default' => '0'
        ),
        'inactive_time'  => array(
            'type' => 'string',
            'default' => '1'
        ),
        'link_position'=>array(
            'type' => 'string',
            'default'=>'top'
        ),
        'button_angle'=>array(
            'type'=>'string',
            'default'=>'0'
        )
	);

    function __construct(){

        add_action( 'init', array( $this, 'arforms_register_gutenberg_blocks') );
        add_action('enqueue_block_editor_assets',array($this,'arf_enqueue_gutenberg_assets'));
        
    }

    function arforms_register_gutenberg_blocks(){
		register_block_type( FORMPATH . '/js/build/arforms-popup', $this->get_block_properties() );

        $script_handle = generate_block_asset_handle( 'arforms/arforms-popup', 'editorScript' );

		wp_set_script_translations( $script_handle, 'ARForms', FORMPATH . '/js/build/arforms-popup/languages/' );

	}

    protected function get_block_properties() {
		$arf_block_attributes = array(
			'render_callback' => array( $this, 'render_block' ),
			'attributes'      => $this->attributes,
		);
		return $arf_block_attributes;
	}

    public function render_block( $attributes = array()  ) {
        $arf_gutenberg_block_css=ARFURL.'/css/arf_gutenberg_style.css';
        $arf_popup="<link rel='stylesheet' type='text/css' href='{$arf_gutenberg_block_css}' />";

        $form_id = !empty( $attributes['form_id'] ) ? $attributes['form_id'] : '';
        if(empty($form_id))
        {
            $arf_popup .= esc_html__("Please select valid form","ARForms");
            return $arf_popup;
        }
        $arf_trigger_type = !empty( $attributes['trigger_type'] ) ? $attributes['trigger_type'] : 'onclick';

        $arf_click_type = isset($attributes['click_type']) ? $attributes['click_type'] : 'link';
        $arf_size_height = isset($attributes['size_height']) ? $attributes['size_height'] : 'auto';
        $arf_size_width = isset($attributes['size_width']) ? $attributes['size_width'] : '800';
        $arf_background_color = isset($attributes['button_bg_color']) ? $attributes['button_bg_color'] : '#8ccf7a';
        $arf_text_color = isset($attributes['button_text_color']) ? $attributes['button_text_color'] : '#ffffff';
        $arf_image_url = isset($attributes['image_url']) ? $attributes['image_url'] : '';
        $arf_image_height = isset($attributes['image_size_height']) ? $attributes['image_size_height'] : 'auto';
        $arf_image_width = isset($attributes['image_size_width']) ? $attributes['image_size_width'] : 'auto';
        $arf_inactive_minute = isset($attributes['inactive_time']) ? $attributes['inactive_time'] : '1';
        $arf_scroll_percentage = isset($attributes['scroll_percentage']) ? $attributes['scroll_percentage'] : '10';
        $arf_time_interval = isset($attributes['popup_time']) ? $attributes['popup_time'] : '0';
        $arf_background_overlay = isset($attributes['background_overlay']) ? $attributes['background_overlay'] : '0.6';
        $arf_show_close_button = isset($attributes['show_close_button']) ? $attributes['show_close_button'] : 'yes';
        $arf_overlay_color = isset($attributes['background_overlay_colorpicker']) ? $attributes['background_overlay_colorpicker'] : '#000000';
        $arf_show_full_screen_popup = isset($attributes['is_show_full_screen_popup']) ? $attributes['is_show_full_screen_popup'] : 'no';
        $inactive_min  = isset($attributes['inactive_min']) ? $attributes['inactive_min'] : '0';
        $arf_animation  = isset($attributes['animation_effect']) ? $attributes['animation_effect'] : 'no_animation';
        $arf_preset_data  = isset($attributes['preset_data']) ? $attributes['preset_data'] : '';
        $arf_hide_popup_loggedinuser  = isset($attributes['hide_popup_loggedin_user']) ? $attributes['hide_popup_loggedin_user'] : 'no';
        $arf_caption = isset($attributes['caption']) ? $attributes['caption'] : addslashes(esc_html__('Click here to open Form', 'ARForms'));
        $arf_link_position = isset($attributes['link_position']) ? $attributes['link_position'] : 'top';
        $arf_button_angle = isset($attributes['button_angle']) ? $attributes['button_angle'] : '0';

        $arf_hide_popup_on_mobile = isset($attributes['hide_popup_on_mobile']) ? $attributes['hide_popup_on_mobile'] : 'no';
        if( $arf_hide_popup_on_mobile == true ){
            $arf_hide_popup_on_mobile = 'yes';
        }

        $form_shortcode="";
     
     if( $arf_show_full_screen_popup == true ){
        $arf_show_full_screen_popup = 'yes';
    }   
    if( $arf_hide_popup_loggedinuser == true ){
        $arf_hide_popup_loggedinuser = 'yes';
    }   
    if( $arf_show_close_button == false ){
        $arf_show_close_button = 'no';
    }

    $params = '';
    if( !empty( $_REQUEST['context'] ) && 'edit' == $_REQUEST['context'] ){
        $params = ' is_gutenberg="true" ';
    }

    switch($arf_trigger_type){
        case 'onclick':
            if( $arf_click_type == 'link' ){
                $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."'  is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' modal_bgcolor='" . $arf_overlay_color . "' arf_hide_popup_loggedinuser='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' {$params} ]";
            } else if( $arf_click_type == 'button' ){
                $form_shortcode=" [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' {$params} ]";
            }
            else if( $arf_click_type == 'image' ){
                $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' arf_img_url='" . $arf_image_url . "' arf_img_height='" . $arf_image_height . "' arf_img_width='" . $arf_image_width . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' {$params}]"; 
            }
            else if( $arf_click_type == 'sticky' ){
                $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' position='" . $arf_link_position . "' height='" . $arf_size_height . "' width='" . $arf_size_width . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' {$params} ]";
            }
            else if( $arf_click_type == 'fly' ){
                $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' position='" . $arf_link_position . "' height='" . $arf_size_height . "' width='" . $arf_size_width . "' angle='" . $arf_button_angle . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' {$params} ]";
            }
        break;
        case 'onload':
            $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' {$params} ]";
        break;
        case 'scroll':
            $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_close_button."' on_scroll='" . $arf_scroll_percentage . "' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' {$params} ]";
        break;
        case 'timer':
            $form_shortcode=" [ARForms_popup id=" . $form_id . " on_delay='" . $arf_time_interval . "' type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' {$params} ]";
        break;
        case 'on_exit':
            $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' is_close_link='" . $arf_show_close_button . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' {$params} ]";
        break;
        case 'on_idle':
            $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' inactive_min='".$arf_inactive_minute."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' {$params} ]";
        break;
    }

    return do_shortcode($form_shortcode);
            
    }

    function arf_enqueue_gutenberg_assets(){

        global $arfversion, $wpdb, $MdlDb,$armainhelper;

        $page = basename($_SERVER['PHP_SELF']);

        if (in_array($page, array('post.php', 'page.php', 'page-new.php', 'post-new.php')) or ( isset($_GET) and isset($_GET['page']) and $_GET['page'] == 'ARForms-entry-templates') ) {
            
            wp_register_script('arforms_gutenberg_script',ARFURL.'/js/arf_gutenberg_script.js',array( 'wp-blocks', 'wp-element', 'wp-i18n', 'wp-components', 'wp-hooks'),$arfversion);
            
            wp_enqueue_script('arforms_gutenberg_script');
            
            wp_register_style('arforms_gutenberg_style',ARFURL.'/css/arf_gutenberg_style.css',array(), $arfversion);
            
            wp_enqueue_style('arforms_gutenberg_style');

        } else if ( in_array($page, array('widgets.php','customize.php')) ) {

            wp_enqueue_script( 'jquery');
            
            wp_register_script('arforms_gutenberg_script',ARFURL.'/js/arf_gutenberg_widget_script.js',array( 'wp-blocks', 'wp-element', 'wp-i18n', 'wp-components', 'wp-hooks'),$arfversion);

            wp_enqueue_script('arforms_gutenberg_script');

            wp_register_style('arforms_gutenberg_style',ARFURL.'/css/arf_gutenberg_style.css',array(), $arfversion);

            wp_enqueue_style('arforms_gutenberg_style');

            $arforms_forms = $MdlDb->forms;

            $arforms_forms_data = $wpdb->get_results("SELECT * FROM `".$arforms_forms."` WHERE is_template=0 AND (status is NULL OR status = '' OR status = 'published') ORDER BY id DESC"); //phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- Reason: $arforms_forms is table name defined globally. False Positive alarm

            $arforms_forms_list = array();
            $n = 0;
            
            foreach( $arforms_forms_data as $k => $value ) {
                $arforms_forms_list[$n]['id'] = $value->id;
                $arforms_forms_list[$n]['label'] = $armainhelper->truncate(html_entity_decode(stripslashes($value->name)),23) . ' (id: '.$value->id.')';
                $n++;
            }
            wp_localize_script(
				'wp-block-editor', 
				'arformslite_gutenberg_script_objects', 
				array(
					'arflite_form_list' => $arforms_forms_list,
					'ajax_url'=>admin_url('admin-ajax.php'),
					'arforms_edit_gutenberg_adminurl'=>admin_url("admin.php?page=ARForms&arfaction=edit")
				)
			);

        } else if ( in_array($page, array('widgets.php','customize.php')) ) {

            wp_enqueue_script( 'jquery');
            
            wp_register_script('arforms_gutenberg_script',ARFURL.'/js/arf_gutenberg_widget_script.js',array( 'wp-blocks', 'wp-element', 'wp-i18n', 'wp-components', 'wp-hooks'),$arfversion);

            wp_enqueue_script('arforms_gutenberg_script');

            $arforms_forms = $MdlDb->forms;

            $arforms_forms_data = $wpdb->get_results("SELECT * FROM `".$arforms_forms."` WHERE is_template=0 AND (status is NULL OR status = '' OR status = 'published') ORDER BY id DESC"); //phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- Reason: $arforms_forms is table name defined globally. False Positive alarm

            $arforms_forms_list = array();
            $n = 0;
            
            foreach( $arforms_forms_data as $k => $value ) {
                $arforms_forms_list[$n]['id'] = $value->id;
                $arforms_forms_list[$n]['label'] = $armainhelper->truncate(html_entity_decode(stripslashes($value->name)),23) . ' (id: '.$value->id.')';
                $n++;
            }
            wp_localize_script(
				'wp-block-editor', 
				'arformslite_gutenberg_script_objects', 
				array(
					'arflite_form_list' => $arforms_forms_list,
					'ajax_url'=>admin_url('admin-ajax.php'),
					'arforms_edit_gutenberg_adminurl'=>admin_url("admin.php?page=ARForms&arfaction=edit")
				)
			);

        }
    }

}

global $arforms_pro_block_widget;
$arforms_pro_block_widget = new arforms_pro_block_widget();