<?php
class arforms_popup_divi_builder{
    function __construct(){
        add_action( 'wp_ajax_arforms_popup_divi_preview', array( $this, 'arforms_popup_divi_module_preview' ) );

        add_action( 'divi_extensions_init', array( $this, 'arforms_load_divi_extension' ) );
    }

    function arforms_popup_divi_module_preview()
    {
        $form_string="";

        $form_id=!empty($_POST['form_popup_id']) ? intval( $_POST['form_popup_id'] ) : ''; 
        $arf_trigger_type =!empty($_POST['arf_trigger_type']) ? sanitize_text_field( $_POST['arf_trigger_type'] ) : 'onclick';  
        $arf_click_type =!empty($_POST['arf_click_type']) ? sanitize_text_field( $_POST['arf_click_type'] ) : 'link';  
        $arf_scroll_percentage =!empty($_POST['arf_scroll_percentage']) ? sanitize_text_field( $_POST['arf_scroll_percentage'] )  : '10';  
        $arf_time_interval =!empty($_POST['arf_time_interval']) ? sanitize_text_field( $_POST['arf_time_interval'] ) : '0';  
        $arf_caption =!empty($_POST['arf_caption']) ? sanitize_text_field( $_POST['arf_caption'] ) : 'Click here to open Form';  
        $arf_background_overlay =!empty($_POST['arf_background_overlay']) ? sanitize_text_field( $_POST['arf_background_overlay'] ) : '0.6';  
        $arf_overlay_color = !empty($_POST['arf_overlay_color']) ? sanitize_text_field( $_POST['arf_overlay_color'] ) : '#D3D3D3';
        $arf_show_close_button =!empty($_POST['arf_show_close_button']) ? sanitize_text_field( $_POST['arf_show_close_button'] ) : 'yes';  
        $arf_image_url =!empty($_POST['arf_image_url']) ? esc_url( $_POST['arf_image_url'] ) : '';  
        $arf_image_height =!empty($_POST['arf_image_height']) ? sanitize_text_field( $_POST['arf_image_height'] ) : 'auto';  
        $arf_image_width =!empty($_POST['arf_image_width']) ? sanitize_text_field( $_POST['arf_image_width'] ) : 'auto';  
        $arf_size_height =!empty($_POST['arf_size_height']) ? sanitize_text_field( $_POST['arf_size_height'] ) : 'auto';  
        $arf_size_width =!empty($_POST['arf_size_width']) ? sanitize_text_field( $_POST['arf_size_width'] ) : '800';  
        $arf_background_color=!empty($_POST['arf_background_color']) ? sanitize_text_field( $_POST['arf_background_color'] ) : '#000000';
        $arf_text_color=!empty($_POST['arf_text_color']) ? sanitize_text_field( $_POST['arf_text_color'] ) : '#FFFFFF';
        $arf_show_full_screen_popup =!empty($_POST['arf_show_full_screen_popup']) ? sanitize_text_field( $_POST['arf_show_full_screen_popup'] ) : 'no';  
        $arf_animation =!empty($_POST['arf_animation']) ? sanitize_text_field( $_POST['arf_animation'] ) : 'no_animation';  
        $arf_link_position =!empty($_POST['arf_link_position']) ? sanitize_text_field( $_POST['arf_link_position'] ) : 'top'; 
        $arf_button_angle =!empty($_POST['arf_button_angle']) ? sanitize_text_field( $_POST['arf_button_angle'] ) : '0';   
        $arf_hide_popup_loggedinuser =!empty($_POST['arf_hide_popup_loggedinuser']) ? sanitize_text_field( $_POST['arf_hide_popup_loggedinuser'] ) : 'no'; 
        $arf_inactive_minute =!empty($_POST['arf_inactive_minute']) ? sanitize_text_field( $_POST['arf_inactive_minute'] ) : '1';          
        $arf_hide_popup_on_mobile = !empty($_POST['arf_hide_popup_on_mobile']) ? sanitize_text_field( $_POST['arf_hide_popup_on_mobile'] ) : 'no';

        if($arf_show_close_button == "on")
        {
            $arf_show_close_button ="yes";
        }
        elseif($arf_show_close_button == "off")
        {
            $arf_show_close_button ="no";
        }

        if($arf_show_full_screen_popup == "on")
        {
            $arf_show_full_screen_popup ="yes";
        }
        elseif($arf_show_full_screen_popup == "off")
        {
            $arf_show_full_screen_popup ="no";
        }

        if($arf_hide_popup_loggedinuser == "on")
        {
            $arf_hide_popup_loggedinuser ="yes";
        }
        elseif($arf_hide_popup_loggedinuser == "off")
        {
            $arf_hide_popup_loggedinuser ="no";
        }
        if($arf_hide_popup_on_mobile == "on")
        {
            $arf_hide_popup_on_mobile ="yes";
        }
        elseif($arf_hide_popup_on_mobile == "off")
        {
            $arf_hide_popup_on_mobile ="no";
        }

        $form_shortcode="";
     

        switch($arf_trigger_type){
            case 'onclick':
                if( $arf_click_type == 'link' ){
                    $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."'  is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' modal_bgcolor='" . $arf_overlay_color . "' arf_hide_popup_loggedinuser='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                } else if( $arf_click_type == 'button' ){
                    $form_shortcode=" [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                }
                else if( $arf_click_type == 'image' ){
                    $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' arf_img_url='" . $arf_image_url . "' arf_img_height='" . $arf_image_height . "' arf_img_width='" . $arf_image_width . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "']"; 
                }
                else if( $arf_click_type == 'sticky' ){
                    $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' position='" . $arf_link_position . "' height='" . $arf_size_height . "' width='" . $arf_size_width . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                }
                else if( $arf_click_type == 'fly' ){
                    $form_shortcode= " [ARForms_popup id=" . $form_id . " desc='" . $arf_caption . "' type='" . $arf_click_type . "' position='" . $arf_link_position . "' height='" . $arf_size_height . "' width='" . $arf_size_width . "' angle='" . $arf_button_angle . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
                }
            break;
            case 'onload':
                $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
            break;
            case 'scroll':
                $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_close_button."' on_scroll='" . $arf_scroll_percentage . "' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
            break;
            case 'timer':
                $form_shortcode=" [ARForms_popup id=" . $form_id . " on_delay='" . $arf_time_interval . "' type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
            break;
            case 'on_exit':
                $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' is_close_link='" . $arf_show_close_button . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
            break;
            case 'on_idle':
                $form_shortcode=" [ARForms_popup id=" . $form_id . " type='" . $arf_trigger_type . "' width='" . $arf_size_width . "' modaleffect='".$arf_animation."' is_fullscreen='".$arf_show_full_screen_popup."' inactive_min='".$arf_inactive_minute."' overlay='" . $arf_background_overlay . "' is_close_link='" . $arf_show_close_button . "' bgcolor='" . $arf_background_color . "' txtcolor='" . $arf_text_color . "' modal_bgcolor='" . $arf_overlay_color . "' hide_popup_for_loggedin_user='" .$arf_hide_popup_loggedinuser. "' hide_popup_on_mobile='" . $arf_hide_popup_on_mobile . "' ]";
            break;
        }

        $form_string= do_shortcode($form_shortcode);
        wp_send_json_success(
            $form_string
		);
    }

    function arforms_load_divi_extension(){
        require_once FORMPATH.'/integrations/Divi/class.arforms_popup_divi_extension.php';
    }
}
global $arforms_popup_divi_builder;
$arforms_popup_divi_builder =new arforms_popup_divi_builder();

?>