<?php
// Load the iContact library
require_once('lib/iContactApi.php');
global $MdlDb;
        
$res = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$MdlDb->autoresponder." WHERE responder_id=%d",8));$res = $res[0]; //phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- Reason: $MdlDb->autoresponder is table name defined globally. False Positive alarm 
$api_key = stripslashes($res->responder_api_key);
$api_username = stripslashes($res->responder_username);
$api_password = stripslashes($res->responder_password);

$data = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$MdlDb->ar." WHERE frm_id = %d", $fid), 'ARRAY_A' ); //phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- Reason: $MdlDb->ar is table name defined globally. False Positive alarm
			
$arr_icontact 	= maybe_unserialize( $data[0]['icontact'] );

$list_id1 = $arr_icontact['type_val'];

if( $list_id1 != '' )
{		
	// Give the API your information
	iContactApi::getInstance()->setConfig(array(
		'appId'       => $api_key, 
		'apiPassword' => $api_password, 
		'apiUsername' => $api_username
	));
	
	// Store the singleton
	$oiContact = iContactApi::getInstance();
	// Try to make the call(s)
	try {
		$contact = $oiContact->addContact($email, null, null, $fname, $lname, null, null, null, null, null, null, null, null, null);
		
		// Get lists
		$lists = $oiContact->getLists();
		
		foreach ($lists as $list) {
			if( $list->listId == $list_id1 ) {
				$list_id = $list->listId;
			}
		}
		// Subscribe contact to list
		$list = $oiContact->subscribeContactToList($contact->contactId, $list_id, 'normal');
		global $arf_debug_log_id;
		$arf_success_msg=array(	
			'success' => 'true',
			'message'     => esc_html("Icontact Authorization Successfully.","ARForms"),
		);
		do_action('arforms_debug_log_entry','icontact_debug_log', 'Icontact Authorization sent response from frontend', 'arforms_icontact_data', $arf_success_msg, $arf_debug_log_id);
		
	} catch (Exception $oException) { // Catch any exceptions
		// Dump errors
		$oiContact->getErrors();
		// Grab the last raw request data
		$oiContact->getLastRequest();
		// Grab the last raw response data
		$oiContact->getLastResponse();

		global $arf_debug_log_id;
		$arf_error_msg=array(	
			'success' => 'false',
			'message'     => $oiContact,
		);
		do_action('arforms_debug_log_entry','icontact_debug_log', 'Icontact Authorization sent response from frontend', 'arforms_icontact_data', $arf_error_msg, $arf_debug_log_id);
	}
}
?>
